/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.entity.EntityHook;
import xerca.xercamod.common.item.Items;

public class ItemGrabHook
extends FishingRodItem {
    public ItemGrabHook() {
        super(new Item.Properties().func_200916_a(ItemGroup.field_78037_j).func_200915_b(210));
        this.setRegistryName("item_grab_hook");
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(ActionResultType.SUCCESS, (Object)heldItem);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        float useSeconds = (float)(this.func_77626_a(stack) - timeLeft) / 20.0f;
        if (useSeconds > 1.0f) {
            useSeconds = 1.0f;
        }
        if (useSeconds > 0.1f && entityLiving instanceof PlayerEntity) {
            Hand hand;
            PlayerEntity playerIn = (PlayerEntity)entityLiving;
            if (playerIn.func_184614_ca().func_77973_b() instanceof ItemGrabHook) {
                hand = Hand.MAIN_HAND;
            } else if (playerIn.func_184592_cb().func_77973_b() instanceof ItemGrabHook) {
                hand = Hand.OFF_HAND;
            } else {
                return;
            }
            ItemStack heldItem = playerIn.func_184586_b(hand);
            playerIn.func_184811_cZ().func_185145_a((Item)this, 40);
            heldItem.func_222118_a(1, (LivingEntity)playerIn, p -> p.func_213334_d(hand));
            if (!worldIn.field_72995_K) {
                worldIn.func_217376_c((Entity)new EntityHook(worldIn, playerIn, heldItem, useSeconds));
            }
            playerIn.func_184609_a(hand);
        }
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnchantmentType.BREAKABLE || enchantment == Items.ENCHANTMENT_GRAPPLING;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isGrabHookEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }
}

