/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CropsBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.item.ArmorStandEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ScytheAttackPacket;

@ParametersAreNonnullByDefault
public class ItemScythe
extends ToolItem {
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of();

    public ItemScythe(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super((float)attackDamageIn, attackSpeedIn, tier, EFFECTIVE_ON, builder.addToolType(ToolType.PICKAXE, tier.func_200925_d()));
    }

    public float func_150893_a(ItemStack stack, BlockState blockState) {
        if (blockState.func_177230_c() instanceof CropsBlock) {
            if (((CropsBlock)blockState.func_177230_c()).func_185525_y(blockState)) {
                return 1.0f;
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, PlayerEntity player) {
        int sweeping = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)itemstack);
        if (sweeping > 0) {
            World world = player.field_70170_p;
            BlockState southBS = world.func_180495_p(pos.func_177968_d());
            BlockState northBS = world.func_180495_p(pos.func_177978_c());
            BlockState westBS = world.func_180495_p(pos.func_177976_e());
            BlockState eastBS = world.func_180495_p(pos.func_177974_f());
            if (this.isMaxCrop(southBS)) {
                this.breakBlock(pos.func_177968_d(), world, player);
            }
            if (this.isMaxCrop(northBS)) {
                this.breakBlock(pos.func_177978_c(), world, player);
            }
            if (this.isMaxCrop(westBS)) {
                this.breakBlock(pos.func_177976_e(), world, player);
            }
            if (this.isMaxCrop(eastBS)) {
                this.breakBlock(pos.func_177974_f(), world, player);
            }
            if (sweeping > 1) {
                BlockState seBS = world.func_180495_p(pos.func_177968_d().func_177974_f());
                BlockState swBS = world.func_180495_p(pos.func_177968_d().func_177976_e());
                BlockState neBS = world.func_180495_p(pos.func_177978_c().func_177976_e());
                BlockState nwBS = world.func_180495_p(pos.func_177978_c().func_177974_f());
                if (this.isMaxCrop(seBS)) {
                    this.breakBlock(pos.func_177968_d().func_177974_f(), world, player);
                }
                if (this.isMaxCrop(swBS)) {
                    this.breakBlock(pos.func_177968_d().func_177976_e(), world, player);
                }
                if (this.isMaxCrop(neBS)) {
                    this.breakBlock(pos.func_177978_c().func_177976_e(), world, player);
                }
                if (this.isMaxCrop(nwBS)) {
                    this.breakBlock(pos.func_177978_c().func_177974_f(), world, player);
                }
            }
        }
        return false;
    }

    private void breakBlock(BlockPos pos, World world, PlayerEntity player) {
        world.func_225521_a_(pos, true, (Entity)player);
    }

    private boolean isMaxCrop(BlockState bs) {
        return bs.func_177230_c() instanceof CropsBlock && ((CropsBlock)bs.func_177230_c()).func_185525_y(bs);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment ench) {
        return ench.field_77351_y == EnchantmentType.BREAKABLE || ench == Enchantments.field_185308_t || ench == Items.ENCHANTMENT_GUILLOTINE || ench == Enchantments.field_185302_k || ench == Enchantments.field_185303_l || ench == Enchantments.field_191530_r || ench == Enchantments.field_180312_n || ench == Enchantments.field_185304_p;
    }

    public static void spawnHead(LivingEntity target) {
        if (target instanceof PlayerEntity) {
            ItemScythe.spawnHead(target.func_200200_C_().getString(), target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        } else if (target.func_200600_R() == EntityType.field_200796_j) {
            ItemScythe.spawnHead("MHF_Cow", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.cow");
        } else if (target.func_200600_R() == EntityType.field_200757_aw) {
            ItemScythe.spawnHead("MHF_Golem", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.iron_golem");
        } else if (target.func_200600_R() == EntityType.field_200781_U) {
            ItemScythe.spawnHead("MHF_Ocelot", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.ocelot");
        } else if (target.func_200600_R() == EntityType.field_200792_f) {
            ItemScythe.spawnHead("MHF_Blaze", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.blaze");
        } else if (target.func_200600_R() == EntityType.field_200784_X) {
            ItemScythe.spawnHead("MHF_Pig", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.pig");
        } else if (target.func_200600_R() == EntityType.field_200743_ai) {
            ItemScythe.spawnHead("MHF_Slime", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.slime");
        } else if (target.func_200600_R() == EntityType.field_200756_av) {
            ItemScythe.spawnHead("MHF_Villager", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.villager");
        } else if (target.func_200600_R() == EntityType.field_200794_h) {
            ItemScythe.spawnHead("MHF_CaveSpider", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.cave_spider");
        } else if (target.func_200600_R() == EntityType.field_200803_q) {
            ItemScythe.spawnHead("MHF_Enderman", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.enderman");
        } else if (target.func_200600_R() == EntityType.field_200771_K) {
            ItemScythe.spawnHead("MHF_LavaSlime", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.magma_cube");
        } else if (target.func_200600_R() == EntityType.field_233592_ba_) {
            ItemScythe.spawnHead("MHF_PigZombie", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.zombie_pigman");
        } else if (target.func_200600_R() == EntityType.field_200748_an) {
            ItemScythe.spawnHead("MHF_Spider", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.spider");
        } else if (target.func_200600_R() == EntityType.field_200795_i) {
            ItemScythe.spawnHead("MHF_Chicken", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.chicken");
        } else if (target.func_200600_R() == EntityType.field_200811_y) {
            ItemScythe.spawnHead("MHF_Ghast", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.ghast");
        } else if (target.func_200600_R() == EntityType.field_200780_T) {
            ItemScythe.spawnHead("MHF_MushroomCow", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.mooshroom");
        } else if (target.func_200600_R() == EntityType.field_200737_ac) {
            ItemScythe.spawnHead("MHF_Sheep", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.sheep");
        } else if (target.func_200600_R() == EntityType.field_200749_ao) {
            ItemScythe.spawnHead("MHF_Squid", target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), "xercamod.head.squid");
        }
    }

    private static void spawnHead(String playerName, World world, double x, double y, double z) {
        ItemScythe.spawnHead(playerName, world, x, y, z, null);
    }

    private static void spawnHead(String playerName, World world, double x, double y, double z, @Nullable String nameTransKey) {
        ItemStack playerHead = new ItemStack((IItemProvider)net.minecraft.item.Items.field_196184_dx, 1);
        playerHead.func_196082_o().func_218657_a("SkullOwner", (INBT)StringNBT.func_229705_a_((String)playerName));
        if (nameTransKey != null) {
            playerHead.func_200302_a((ITextComponent)new TranslationTextComponent(nameTransKey));
        }
        InventoryHelper.func_180173_a((World)world, (double)x, (double)y, (double)z, (ItemStack)playerHead);
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isScytheEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }

    public boolean onLeftClickEntity(ItemStack stack, PlayerEntity player, Entity entity) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_191530_r, (ItemStack)stack) > 0) {
            boolean sweep;
            float damage = (float)player.func_110148_a(Attributes.field_233823_f_).func_111126_e();
            float bonusDamage = entity instanceof LivingEntity ? EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)entity).func_70668_bt()) : EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
            float cooldownStrength = player.func_184825_o(0.5f);
            damage *= 0.2f + cooldownStrength * cooldownStrength * 0.8f;
            damage += (bonusDamage *= cooldownStrength);
            boolean cooledAttack = cooldownStrength > 0.9f;
            boolean cooledSprintAttack = player.func_70051_ag() && cooledAttack;
            boolean critical = cooledAttack && player.field_70143_R > 0.0f && !player.func_233570_aj_() && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Effects.field_76440_q) && !player.func_184218_aH() && entity instanceof LivingEntity && !player.func_70051_ag();
            double d0 = player.field_70140_Q - player.field_70141_P;
            boolean bl = sweep = cooledAttack && !critical && !cooledSprintAttack && player.func_233570_aj_() && d0 < (double)player.func_70689_ay();
            if (sweep) {
                float sweepDamage = 1.0f + EnchantmentHelper.func_191527_a((LivingEntity)player) * damage;
                for (LivingEntity livingentity : player.field_70170_p.func_217357_a(LivingEntity.class, entity.func_174813_aQ().func_72314_b(1.0, 0.25, 1.0))) {
                    if (livingentity == player || livingentity == entity || player.func_184191_r((Entity)livingentity) || livingentity instanceof ArmorStandEntity && ((ArmorStandEntity)livingentity).func_181026_s() || !(player.func_70068_e((Entity)livingentity) < 9.0)) continue;
                    livingentity.func_233627_a_(0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                    livingentity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), sweepDamage);
                }
                player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                player.func_184810_cG();
            }
        }
        return false;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)heldItem) > 0) {
            playerIn.func_184598_c(hand);
            return ActionResult.func_226248_a_((Object)heldItem);
        }
        return ActionResult.func_226250_c_((Object)heldItem);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return UseAction.BOW;
        }
        return UseAction.NONE;
    }

    public int func_77626_a(ItemStack stack) {
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) > 0) {
            return 72000;
        }
        return 0;
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        if (EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_GUILLOTINE, (ItemStack)stack) <= 0) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        float f = (float)(this.func_77626_a(stack) - timeLeft) / 20.0f;
        if (f > 1.0f) {
            f = 1.0f;
        }
        if ((double)f >= 0.9) {
            player.func_184609_a(Hand.MAIN_HAND);
            if (worldIn.field_72995_K) {
                Minecraft mine = Minecraft.func_71410_x();
                if (mine.field_71476_x != null && mine.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    Entity target = ((EntityRayTraceResult)mine.field_71476_x).func_216348_a();
                    ScytheAttackPacket pack = new ScytheAttackPacket(f, target.func_145782_y());
                    XercaMod.NETWORK_HANDLER.sendToServer((Object)pack);
                }
            }
        }
    }
}

