/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.KnifeAttackPacket;

public class KnifeAttackPacketHandler {
    public static void handle(KnifeAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when KnifeAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> KnifeAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(KnifeAttackPacket msg, ServerPlayerEntity pl) {
        Entity target = pl.field_70170_p.func_73045_a(msg.getTargetId());
        ItemStack st = pl.func_184592_cb();
        if (st.func_77973_b() != Items.ITEM_KNIFE) {
            XercaMod.LOGGER.warn("No knife at offhand!");
            return;
        }
        if (target instanceof LivingEntity) {
            st.func_77973_b().func_77644_a(st, (LivingEntity)target, (LivingEntity)pl);
            float enchantBonus = EnchantmentHelper.func_152377_a((ItemStack)st, (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)pl), 3.0f + enchantBonus);
            if (enchantBonus > 0.0f) {
                pl.func_71047_c(target);
                pl.field_70170_p.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), SoundEvents.field_187727_dV, pl.func_184176_by(), 1.0f, 1.0f);
            } else {
                pl.field_70170_p.func_184148_a(null, pl.func_226277_ct_(), pl.func_226278_cu_(), pl.func_226281_cx_(), SoundEvents.field_187733_dX, pl.func_184176_by(), 1.0f, 1.0f);
            }
        }
    }
}

