/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamod.common.packets.QuakeParticlePacket;

public class QuakeParticlePacketHandler {
    public static void handle(QuakeParticlePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ctx.get().enqueueWork(() -> QuakeParticlePacketHandler.processMessage(message));
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void processMessage(QuakeParticlePacket pkt) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        Vector3d centerPos = new Vector3d(pkt.getPosX(), pkt.getPosY(), pkt.getPosZ());
        for (int j = 0; j < pkt.getCount(); ++j) {
            double posX = centerPos.field_72450_a + world.field_73012_v.nextGaussian();
            double posY = centerPos.field_72448_b;
            double posZ = centerPos.field_72449_c + world.field_73012_v.nextGaussian();
            Vector3d particlePos = new Vector3d(posX, posY, posZ);
            Vector3d particleVel = particlePos.func_178788_d(centerPos).func_72432_b().func_186678_a(0.15);
            world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, posX, posY, posZ, particleVel.field_72450_a, 0.01, particleVel.field_72449_c);
        }
    }
}

