/*
 * Decompiled with CFR 0.152.
 */
package bobsans.simplehomes.command;

import bobsans.simplehomes.config.Config;
import bobsans.simplehomes.types.PlayerData;
import bobsans.simplehomes.types.WarpPoint;
import bobsans.simplehomes.utils.PlayerTeleporter;
import bobsans.simplehomes.utils.Storage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandWarp
extends CommandBase {
    public String func_71517_b() {
        return "warp";
    }

    public String func_71518_a(ICommandSender sender) {
        return "Use /warp <name> for teleport to passed warp location.";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayer && Config.ALLOW_WARP_POINTS;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        EntityPlayer player = (EntityPlayer)sender;
        ArrayList<String> result = new ArrayList<String>();
        Storage storage = Storage.get(player.field_70170_p);
        if (storage == null) {
            return result;
        }
        PlayerData data = storage.load(PlayerData.class, player.func_110124_au().toString());
        if (args.length == 1) {
            for (String name : data.warps.keySet()) {
                if (!name.startsWith(args[0])) continue;
                result.add(name);
            }
        } else {
            result.addAll(data.warps.keySet());
        }
        return result;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 1) {
            EntityPlayer player = (EntityPlayer)sender;
            Storage storage = Storage.get(player.field_70170_p);
            if (storage == null) {
                throw new CommandException("Unable to load warp list.", new Object[0]);
            }
            PlayerData data = storage.load(PlayerData.class, player.func_110124_au().toString());
            for (Map.Entry<String, WarpPoint> entry : data.warps.entrySet()) {
                if (!entry.getKey().equals(args[0])) continue;
                PlayerTeleporter.transferPlayer(server, player, entry.getValue());
                return;
            }
            throw new CommandException("Warp point with name \"" + args[0] + "\" not exist!", new Object[0]);
        }
        throw new WrongUsageException("Command /warp take one arguments.", new Object[0]);
    }
}

