/*
 * Decompiled with CFR 0.152.
 */
package bobsans.simplehomes.config;

import bobsans.simplehomes.config.ConfigItem;
import java.io.File;
import java.util.ArrayList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static boolean ALLOW_WARP_POINTS = true;
    public static int MAXIMUM_WARP_POINTS = 10;
    public static Configuration config;

    public static void init(File configFile) {
        config = new Configuration(configFile);
        Config.syncConfig();
        MinecraftForge.EVENT_BUS.register(ConfigChangeHandler.class);
    }

    private static void syncConfig() {
        config.load();
        ArrayList<String> orderedKeys = new ArrayList<String>();
        ALLOW_WARP_POINTS = config.getBoolean(ConfigItem.ALLOW_WARP_POINTS.key(), "general", true, ConfigItem.ALLOW_WARP_POINTS.desc(), ConfigItem.ALLOW_WARP_POINTS.languageKey());
        orderedKeys.add(ConfigItem.ALLOW_WARP_POINTS.key());
        MAXIMUM_WARP_POINTS = config.getInt(ConfigItem.MAXIMUM_WARP_POINTS.key(), "general", 10, 0, 100, ConfigItem.MAXIMUM_WARP_POINTS.desc(), ConfigItem.MAXIMUM_WARP_POINTS.languageKey());
        orderedKeys.add(ConfigItem.MAXIMUM_WARP_POINTS.key());
        config.setCategoryPropertyOrder("general", orderedKeys);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static class ConfigChangeHandler {
        @SubscribeEvent(priority=EventPriority.NORMAL)
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if ("simplehomes".equals(event.getModID())) {
                config.save();
                Config.syncConfig();
            }
        }
    }
}

