/*
 * Decompiled with CFR 0.152.
 */
package bobsans.simplehomes.types;

import bobsans.simplehomes.types.WarpPoint;
import bobsans.simplehomes.utils.NBTSerialized;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerData
implements NBTSerialized {
    public String uid;
    public String name;
    public WarpPoint home = null;
    public Map<String, WarpPoint> warps = new HashMap<String, WarpPoint>();

    public PlayerData(EntityPlayer player) {
        this.setPlayer(player);
    }

    public PlayerData(NBTTagCompound tag) {
        this.updateFromNBT(tag);
    }

    public PlayerData setPlayer(EntityPlayer player) {
        this.uid = player.func_110124_au().toString();
        this.name = player.func_70005_c_();
        return this;
    }

    public PlayerData updateFromNBT(NBTTagCompound tag) {
        this.uid = tag.func_74779_i("uid");
        this.name = tag.func_74779_i("name");
        NBTTagCompound homeTag = tag.func_74775_l("home");
        if (homeTag.func_186856_d() != 0) {
            this.home = new WarpPoint(homeTag);
        }
        NBTTagCompound warpsTag = tag.func_74775_l("warps");
        for (String key : warpsTag.func_150296_c()) {
            this.warps.put(key, new WarpPoint(warpsTag.func_74775_l(key)));
        }
        return this;
    }

    public PlayerData setHome(WarpPoint home) {
        this.home = home;
        return this;
    }

    public PlayerData addWarp(WarpPoint point) {
        this.warps.put(point.name, point);
        return this;
    }

    @Override
    public String getNBTKey() {
        return this.uid;
    }

    @Override
    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uid", this.uid);
        tag.func_74778_a("name", this.name);
        if (this.home != null) {
            tag.func_74782_a("home", (NBTBase)this.home.toNBT());
        }
        if (!this.warps.isEmpty()) {
            NBTTagCompound warpsTag = new NBTTagCompound();
            for (Map.Entry<String, WarpPoint> warp : this.warps.entrySet()) {
                warpsTag.func_74782_a(warp.getKey(), (NBTBase)warp.getValue().toNBT());
            }
            tag.func_74782_a("warps", (NBTBase)warpsTag);
        }
        return tag;
    }
}

