/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.client;

import com.github.ipixeli.gender.client.GenderClient;
import com.github.ipixeli.gender.client.MCAccessor;
import com.github.ipixeli.gender.client.Renders;
import com.github.ipixeli.gender.client.gui.ScreenConfig;
import com.github.ipixeli.gender.client.gui.ScreenProfile;
import com.github.ipixeli.gender.core.Gender;
import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.client.Logic;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.gui.widget.ModListWidget;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gender", value={Dist.CLIENT})
public final class ClientEvents {
    private static boolean needSendPacket = false;

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x() == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (needSendPacket && mc != null && mc.field_71441_e != null && mc.field_71439_g != null && mc.func_147114_u() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        }
        if (mc.field_71462_r == null && GenderClient.key.func_151468_f()) {
            mc.func_147108_a((Screen)new ScreenProfile());
        }
    }

    @SubscribeEvent
    public static void onEvent(WorldEvent.Load e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g != null && mc.func_147114_u() != null) {
            Gender.client().onLogin();
            needSendPacket = false;
        } else {
            needSendPacket = true;
        }
    }

    @SubscribeEvent
    public static void onEvent(WorldEvent.Unload e) {
        Gender.client().onLogout();
    }

    private static String handleName(PlayerEntity p, String old) {
        MCAccessor mca = MCAccessor.instance();
        String n = mca.getName(p);
        String u = mca.getUuid(p);
        boolean isSelf = mca.isSelf(p);
        boolean isGuiRender = Renders.isGuiRender();
        String label = Renders.label(n, u, isSelf, isGuiRender, old);
        return label;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(PlayerEvent.NameFormat e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        e.setDisplayname(ClientEvents.handleName((PlayerEntity)e.getEntity(), e.getDisplayname()));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(RenderNameplateEvent e) {
        if (e.getEntity() == null || !(e.getEntity() instanceof PlayerEntity)) {
            return;
        }
        e.setContent(ClientEvents.handleName((PlayerEntity)e.getEntity(), e.getContent()));
    }

    @SubscribeEvent
    public static void onEvent(PlaySoundAtEntityEvent e) {
        if (!Config.playerGenders.getValue().booleanValue() || !Config.playerGenderSounds.getValue().booleanValue()) {
            return;
        }
        if (e.getEntity() == null || !(e.getEntity() instanceof AbstractClientPlayerEntity)) {
            return;
        }
        if (e.getSound() != null && e.getSound().func_187503_a() != null && e.getSound().func_187503_a().toString().contains("entity.player.hurt")) {
            AbstractClientPlayerEntity p = (AbstractClientPlayerEntity)e.getEntity();
            MCAccessor mca = MCAccessor.instance();
            String uuid = "" + mca.getUuid((PlayerEntity)p);
            String name = mca.getName((PlayerEntity)p);
            boolean isSelf = mca.isSelf((PlayerEntity)p);
            EnumAge age = Logic.getVisibleAge(name, uuid.toString(), isSelf, Renders.isGuiRender());
            EnumGender gender = Logic.getVisibleGender(name, uuid.toString(), isSelf, Renders.isGuiRender());
            BlockPos pos = p.func_180425_c();
            Gender.client().onHurtSound(age, gender, pos.func_177958_n(), (float)pos.func_177956_o() - 0.1f, pos.func_177952_p());
            e.setCanceled(true);
        }
    }

    private static ModListWidget.ModEntry isIfModDisplayed(ModListScreen screen) {
        try {
            Field selected = screen.getClass().getDeclaredField("selected");
            selected.setAccessible(true);
            return (ModListWidget.ModEntry)selected.get(screen);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Button getButton(ModListScreen screen) {
        try {
            Field f = screen.getClass().getDeclaredField("configButton");
            f.setAccessible(true);
            return (Button)f.get(screen);
        }
        catch (Exception e) {
            return null;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEvent(GuiScreenEvent.DrawScreenEvent.Post e) {
        ModListScreen screen;
        ModListWidget.ModEntry entry;
        if (e.getGui() instanceof ModListScreen && (entry = ClientEvents.isIfModDisplayed(screen = (ModListScreen)e.getGui())) != null && entry.getInfo().getModId().equals("gender")) {
            Button button = ClientEvents.getButton(screen);
            button.active = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEvent(GuiScreenEvent.MouseClickedEvent.Pre e) {
        Button button;
        ModListScreen screen;
        ModListWidget.ModEntry entry;
        if (e.getGui() instanceof ModListScreen && (entry = ClientEvents.isIfModDisplayed(screen = (ModListScreen)e.getGui())) != null && entry.getInfo().getModId().equals("gender") && (button = ClientEvents.getButton(screen)).isMouseOver(e.getMouseX(), e.getMouseY())) {
            MCAccessor.instance().displayScreen(new ScreenConfig(true));
            e.setCanceled(true);
        }
    }
}

