/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.core.profiles;

import com.github.ipixeli.gender.core.client.Config;
import com.github.ipixeli.gender.core.profiles.EnumAge;
import com.github.ipixeli.gender.core.profiles.EnumGender;
import com.github.ipixeli.gender.core.profiles.EnumModel;

public final class PlayerProfile {
    private String name = "";
    private String uuid = "";
    private EnumGender gender = EnumGender.UNSET;
    private EnumAge age = EnumAge.UNSET;
    private EnumModel model = EnumModel.UNSET;

    public PlayerProfile(String n, String u) {
        this.name = n;
        this.uuid = u;
    }

    public PlayerProfile(String n, String u, EnumAge a, EnumGender g, EnumModel m) {
        this.name = n;
        this.uuid = u;
        this.age = a;
        this.gender = g;
        this.model = m;
    }

    public String name() {
        return this.name;
    }

    public String uuid() {
        return this.uuid;
    }

    public EnumAge getAge() {
        return this.age;
    }

    public EnumGender getGender() {
        return this.gender;
    }

    public EnumModel getModel() {
        return this.model;
    }

    public void setUsername(String s) {
        this.name = s;
    }

    public void setUUID(String s) {
        this.uuid = s;
    }

    public void setAge(EnumAge v) {
        this.age = v;
        if (v.equals(EnumAge.CHILD)) {
            this.setModel(EnumModel.NONE);
        } else if (this.gender.equals(EnumGender.FEMALE)) {
            this.setModel((EnumModel)Config.defaultPlayerFemaleModel.value);
        } else if (this.gender.equals(EnumGender.OTHER)) {
            this.setModel(EnumModel.UNSET);
        }
    }

    public void setGender(EnumGender v) {
        this.gender = v;
        if (v.equals(EnumGender.FEMALE) && this.model.equals(EnumModel.UNSET)) {
            this.setModel(EnumModel.STEPHANIE);
        } else if (v.equals(EnumGender.MALE)) {
            this.setModel(EnumModel.NONE);
        } else if (this.gender.equals(EnumGender.OTHER)) {
            this.setModel(EnumModel.UNSET);
        }
    }

    public void setModel(EnumModel v) {
        this.model = this.gender.equals(EnumGender.MALE) ? EnumModel.UNSET : (this.age.equals(EnumAge.CHILD) ? EnumModel.NONE : v);
    }

    public boolean isSamePlayer(PlayerProfile p2) {
        return this.name().equals(p2.name()) && this.uuid().equals(p2.uuid());
    }
}

