/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.BlockPocketTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.EntitySelectionContext;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockPocketWallBlock
extends OwnableBlock
implements IOverlayDisplay {
    public static final BooleanProperty SEE_THROUGH = BooleanProperty.func_177716_a((String)"see_through");
    public static final BooleanProperty SOLID = BooleanProperty.func_177716_a((String)"solid");

    public BlockPocketWallBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(-1.0f, 6000000.0f).func_200942_a().func_235828_a_(BlockPocketWallBlock::isNormalCube).func_235842_b_(BlockPocketWallBlock::causesSuffocation));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)SEE_THROUGH, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)SOLID, (Comparable)Boolean.valueOf(false)));
    }

    public static boolean isNormalCube(BlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public static boolean causesSuffocation(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)SOLID);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        TileEntity te1;
        Entity entity;
        if (!((Boolean)state.func_177229_b((Property)SOLID)).booleanValue() && ctx instanceof EntitySelectionContext && (entity = ((EntitySelectionContext)ctx).getEntity()) instanceof PlayerEntity && (te1 = world.func_175625_s(pos)) instanceof BlockPocketTileEntity) {
            BlockPocketTileEntity te = (BlockPocketTileEntity)te1;
            if (te.getManager() == null) {
                return VoxelShapes.func_197880_a();
            }
            if (te.getManager().hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(te.getManager().func_145831_w(), te.getManager().func_174877_v(), ModuleType.WHITELIST).contains(entity.func_200200_C_().getString().toLowerCase())) {
                return VoxelShapes.func_197880_a();
            }
            if (!te.getOwner().isOwner((PlayerEntity)entity)) {
                return VoxelShapes.func_197868_b();
            }
            return VoxelShapes.func_197880_a();
        }
        return VoxelShapes.func_197868_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return (Boolean)state.func_177229_b((Property)SEE_THROUGH) != false && adjacentBlockState.func_177230_c() == SCContent.BLOCK_POCKET_WALL.get();
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)super.func_196258_a(context).func_206870_a((Property)SEE_THROUGH, (Comparable)Boolean.valueOf(true));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{SEE_THROUGH, SOLID});
    }

    @Override
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new BlockPocketTileEntity();
    }

    @Override
    public ItemStack getDisplayStack(World world, BlockState state, BlockPos pos) {
        return new ItemStack((IItemProvider)SCContent.BLOCK_POCKET_WALL.get(), 1);
    }

    @Override
    public boolean shouldShowSCInfo(World world, BlockState state, BlockPos pos) {
        return true;
    }
}

