/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class DisguisableBlock
extends OwnableBlock
implements IOverlayDisplay {
    public DisguisableBlock(AbstractBlock.Properties properties) {
        super(properties.func_226896_b_().func_235828_a_(DisguisableBlock::isNormalCube).func_235842_b_(DisguisableBlock::causesSuffocation));
    }

    public DisguisableBlock(SoundType soundType, AbstractBlock.Properties properties) {
        super(soundType, properties.func_226896_b_().func_235828_a_(DisguisableBlock::isNormalCube).func_235842_b_(DisguisableBlock::causesSuffocation));
    }

    public static boolean isNormalCube(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState;
        if (state.func_177230_c() instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)state.func_177230_c()).getDisguisedStateOrDefault(state, world, pos)).func_177230_c() != state.func_177230_c()) {
            return disguisedState.func_215686_e(world, pos);
        }
        return state.func_185904_a().func_76218_k() && state.func_235785_r_(world, pos);
    }

    public static boolean causesSuffocation(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState;
        if (state.func_177230_c() instanceof DisguisableBlock && (disguisedState = ((DisguisableBlock)state.func_177230_c()).getDisguisedStateOrDefault(state, world, pos)).func_177230_c() != state.func_177230_c()) {
            return disguisedState.func_215696_m(world, pos);
        }
        return state.func_185904_a().func_76230_c() && state.func_235785_r_(world, pos);
    }

    public SoundType getSoundType(BlockState state, IWorldReader world, BlockPos pos, Entity entity) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, (IBlockReader)world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.getSoundType(world, pos, entity);
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215700_a(world, pos, ctx);
        }
        return super.func_220053_a(state, world, pos, ctx);
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215685_b(world, pos, ctx);
        }
        return super.func_220071_b(state, world, pos, ctx);
    }

    public VoxelShape func_196247_c(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_196951_e(world, pos);
        }
        return super.func_196247_c(state, world, pos);
    }

    public float func_220080_a(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedStateOrDefault(state, world, pos);
        if (disguisedState.func_177230_c() != this) {
            return disguisedState.func_215703_d(world, pos);
        }
        return super.func_220080_a(state, world, pos);
    }

    public final BlockState getDisguisedStateOrDefault(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState disguisedState = this.getDisguisedBlockState(world, pos);
        return disguisedState != null ? disguisedState : state;
    }

    public BlockState getDisguisedBlockState(IBlockReader world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof DisguisableTileEntity) {
            ItemStack module;
            DisguisableTileEntity te = (DisguisableTileEntity)world.func_175625_s(pos);
            ItemStack itemStack = module = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!module.func_190926_b() && !((ModuleItem)module.func_77973_b()).getBlockAddons(module.func_77978_p()).isEmpty()) {
                return ((ModuleItem)module.func_77973_b()).getBlockAddons(module.func_77978_p()).get(0).func_176223_P();
            }
        }
        return null;
    }

    public ItemStack getDisguisedStack(IBlockReader world, BlockPos pos) {
        if (world != null && world.func_175625_s(pos) instanceof DisguisableTileEntity) {
            ItemStack disguisedStack;
            ItemStack stack;
            DisguisableTileEntity te = (DisguisableTileEntity)world.func_175625_s(pos);
            ItemStack itemStack = stack = te.hasModule(ModuleType.DISGUISE) ? te.getModule(ModuleType.DISGUISE) : ItemStack.field_190927_a;
            if (!stack.func_190926_b() && !((ModuleItem)stack.func_77973_b()).getBlockAddons(stack.func_77978_p()).isEmpty() && Block.func_149634_a((Item)(disguisedStack = ((ModuleItem)stack.func_77973_b()).getAddons(stack.func_77978_p()).get(0)).func_77973_b()) != this) {
                return disguisedStack;
            }
        }
        return new ItemStack((IItemProvider)this);
    }

    @Override
    public ItemStack getDisplayStack(World world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockReader)world, pos);
    }

    @Override
    public boolean shouldShowSCInfo(World world, BlockState state, BlockPos pos) {
        return this.getDisguisedStack((IBlockReader)world, pos).func_77973_b() == this.func_199767_j();
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getDisguisedStack(world, pos);
    }
}

