/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SCTags;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.blocks.OwnableBlock;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class BaseReinforcedBlock
extends OwnableBlock
implements IReinforcedBlock {
    private final Supplier<Block> vanillaBlockSupplier;

    public BaseReinforcedBlock(Material mat, Block vB) {
        this(mat, vB, 0);
    }

    public BaseReinforcedBlock(Material mat, Block vB, int lightValue) {
        this(SoundType.field_185851_d, mat, vB, (BlockState state) -> lightValue);
    }

    public BaseReinforcedBlock(SoundType soundType, Material mat, Block vB) {
        this(soundType, mat, vB, (BlockState state) -> 0);
    }

    public BaseReinforcedBlock(AbstractBlock.Properties properties, Block vB) {
        super(properties.func_200948_a(-1.0f, 6000000.0f));
        this.vanillaBlockSupplier = () -> vB;
    }

    public BaseReinforcedBlock(AbstractBlock.Properties properties, SoundType soundType, Block vB) {
        super(soundType, properties.func_226896_b_());
        this.vanillaBlockSupplier = () -> vB;
    }

    public BaseReinforcedBlock(SoundType soundType, Material mat, Block vB, float slipperiness) {
        super(soundType, AbstractBlock.Properties.func_200945_a((Material)mat).func_200948_a(-1.0f, 6000000.0f).func_200941_a(slipperiness));
        this.vanillaBlockSupplier = () -> vB;
    }

    public BaseReinforcedBlock(SoundType soundType, Material mat, Block vB, ToIntFunction<BlockState> lightValue) {
        super(soundType, AbstractBlock.Properties.func_200945_a((Material)mat).func_200948_a(-1.0f, 6000000.0f).func_235838_a_(lightValue));
        this.vanillaBlockSupplier = () -> vB;
    }

    public BaseReinforcedBlock(SoundType soundType, Material mat, Supplier<Block> vB) {
        super(soundType, AbstractBlock.Properties.func_200945_a((Material)mat).func_200948_a(-1.0f, 6000000.0f));
        this.vanillaBlockSupplier = vB;
    }

    public BaseReinforcedBlock(SoundType soundType, Material mat, Supplier<Block> vB, ToIntFunction<BlockState> lightValue) {
        super(soundType, AbstractBlock.Properties.func_200945_a((Material)mat).func_200948_a(-1.0f, 6000000.0f).func_235838_a_(lightValue));
        this.vanillaBlockSupplier = vB;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (this == SCContent.REINFORCED_COBWEB.get()) {
            TileEntity te;
            if (entity instanceof PlayerEntity && (te = world.func_175625_s(pos)) instanceof OwnableTileEntity && ((OwnableTileEntity)te).getOwner().isOwner((PlayerEntity)entity)) {
                return;
            }
            entity.func_213295_a(state, new Vector3d(0.25, 0.05, 0.25));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this == SCContent.REINFORCED_GRASS_PATH.get() ? Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0) : VoxelShapes.func_197868_b();
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this == SCContent.REINFORCED_COBWEB.get() ? VoxelShapes.func_197880_a() : this.func_220053_a(state, world, pos, context);
    }

    public boolean isFireSource(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return this == SCContent.REINFORCED_NETHERRACK.get() && side == Direction.UP;
    }

    public boolean canSustainPlant(BlockState state, IBlockReader world, BlockPos pos, Direction facing, IPlantable plantable) {
        BlockState plant = plantable.getPlant(world, pos.func_177972_a(facing));
        PlantType type = plantable.getPlantType(world, pos.func_177972_a(facing));
        if (plant.func_177230_c() == Blocks.field_150434_aF) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
        }
        if (type == PlantType.DESERT) {
            return this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
        }
        if (type == PlantType.CAVE) {
            return Block.func_220056_d((BlockState)state, (IBlockReader)world, (BlockPos)pos, (Direction)Direction.UP);
        }
        if (type == PlantType.PLAINS) {
            return this.func_203417_a((ITag)SCTags.Blocks.REINFORCED_DIRT);
        }
        if (type == PlantType.BEACH) {
            boolean isBeach = this.func_203417_a((ITag)SCTags.Blocks.REINFORCED_DIRT) || this == SCContent.REINFORCED_SAND.get() || this == SCContent.REINFORCED_RED_SAND.get();
            boolean hasWater = world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            return isBeach && hasWater;
        }
        return false;
    }

    public boolean isConduitFrame(BlockState state, IWorldReader world, BlockPos pos, BlockPos conduit) {
        return this == SCContent.REINFORCED_PRISMARINE.get() || this == SCContent.REINFORCED_PRISMARINE_BRICKS.get() || this == SCContent.REINFORCED_SEA_LANTERN.get() || this == SCContent.REINFORCED_DARK_PRISMARINE.get();
    }

    public boolean isPortalFrame(BlockState state, IWorldReader world, BlockPos pos) {
        return this == SCContent.REINFORCED_OBSIDIAN.get();
    }

    public float getEnchantPowerBonus(BlockState state, IWorldReader world, BlockPos pos) {
        return this == SCContent.REINFORCED_BOOKSHELF.get() ? 1.0f : 0.0f;
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        if (this.getVanillaBlock() instanceof BreakableBlock) {
            return adjacentBlockState.func_177230_c() == this ? true : super.func_200122_a(state, adjacentBlockState, side);
        }
        return false;
    }

    public boolean func_149653_t(BlockState state) {
        return this == SCContent.REINFORCED_ICE.get();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (this == SCContent.REINFORCED_ICE.get() && world.func_226658_a_(LightType.BLOCK, pos) > 11 - state.func_200016_a((IBlockReader)world, pos)) {
            if (world.func_230315_m_().func_236040_e_()) {
                world.func_217377_a(pos, false);
            } else {
                world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
                world.func_190524_a(pos, Blocks.field_150355_j, pos);
            }
        }
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlockSupplier.get();
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return this.func_176223_P();
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }
}

