/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.WhitelistOnlyTileEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class ReinforcedButtonBlock
extends AbstractButtonBlock
implements IReinforcedBlock {
    public static final AbstractBlock.Properties STONE_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200948_a(-1.0f, 6000000.0f);
    public static final AbstractBlock.Properties WOOD_PROPERTIES = AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185848_a);
    private final Block vanillaBlock;
    public boolean isWoodenButton;

    public ReinforcedButtonBlock(boolean isWooden, AbstractBlock.Properties properties, Block vb) {
        super(isWooden, properties);
        this.isWoodenButton = isWooden;
        this.vanillaBlock = vb;
    }

    public SoundEvent func_196369_b(boolean powered) {
        if (this.isWoodenButton) {
            return powered ? SoundEvents.field_187885_gS : SoundEvents.field_187883_gR;
        }
        return powered ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTrace) {
        if (this.isAllowedToPress(world, pos, (WhitelistOnlyTileEntity)world.func_175625_s(pos), player)) {
            return super.func_225533_a_(state, world, pos, player, hand, rayTrace);
        }
        return ActionResultType.FAIL;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, WhitelistOnlyTileEntity te, PlayerEntity entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.getPlayersFromModule(world, pos, ModuleType.WHITELIST).contains(entity.func_200200_C_().func_150261_e().toLowerCase());
    }

    @Override
    public Block getVanillaBlock() {
        return this.vanillaBlock;
    }

    @Override
    public BlockState getConvertedState(BlockState vanillaState) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_196366_M, vanillaState.func_177229_b((Property)field_196366_M))).func_206870_a((Property)field_185512_D, vanillaState.func_177229_b((Property)field_185512_D))).func_206870_a((Property)field_176584_b, vanillaState.func_177229_b((Property)field_176584_b));
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return NonNullList.func_193580_a((Object)ItemStack.field_190927_a, (Object[])new ItemStack[]{new ItemStack((IItemProvider)this)});
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof PlayerEntity) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (PlayerEntity)placer));
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WhitelistOnlyTileEntity();
    }
}

