/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.BulletEntity;
import net.geforcemods.securitycraft.entity.ai.AttackRangedIfEnabledGoal;
import net.geforcemods.securitycraft.entity.ai.TargetNearestPlayerOrMobGoal;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class SentryEntity
extends CreatureEntity
implements IRangedAttackMob {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(SentryEntity.class, Owner.getSerializer());
    private static final DataParameter<CompoundNBT> MODULE = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<CompoundNBT> WHITELIST = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Integer> MODE = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> HEAD_ROTATION = EntityDataManager.func_187226_a(SentryEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private float headYTranslation = 0.9f;
    private final float animationStepSize = 0.025f;
    public boolean animateUpwards = true;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public SentryEntity(EntityType<SentryEntity> type, World world) {
        super(SCContent.eTypeSentry, world);
    }

    public void setupSentry(PlayerEntity owner) {
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.func_200200_C_().getString(), PlayerEntity.func_146094_a((GameProfile)owner.func_146103_bH()).toString()));
        this.field_70180_af.func_187227_b(MODULE, (Object)new CompoundNBT());
        this.field_70180_af.func_187227_b(WHITELIST, (Object)new CompoundNBT());
        this.field_70180_af.func_187227_b(MODE, (Object)SentryMode.CAMOUFLAGE.ordinal());
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
        this.field_70180_af.func_187214_a(MODULE, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(WHITELIST, (Object)new CompoundNBT());
        this.field_70180_af.func_187214_a(MODE, (Object)SentryMode.CAMOUFLAGE.ordinal());
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackRangedIfEnabledGoal(this, 5, 10.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new TargetNearestPlayerOrMobGoal(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (!this.animate && this.headYTranslation > 0.0f && (Integer)this.field_70180_af.func_187225_a(MODE) == 0) {
                this.animateUpwards = true;
                this.animate = true;
            }
            if (this.animate) {
                if (this.animateUpwards && this.headYTranslation > 0.0f) {
                    this.headYTranslation -= 0.025f;
                    if (this.headYTranslation <= 0.0f) {
                        this.animateUpwards = false;
                        this.animate = false;
                    }
                } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                    this.headYTranslation += 0.025f;
                    if (this.headYTranslation >= 0.9f) {
                        this.animateUpwards = true;
                        this.animate = false;
                    }
                }
            }
        }
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SCContent.SENTRY.get());
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        BlockPos pos = this.func_233580_cy_();
        if (this.getOwner().isOwner(player) && hand == Hand.MAIN_HAND) {
            Item item = player.func_184614_ca().func_77973_b();
            player.func_71053_j();
            if (player.func_213453_ef()) {
                this.func_70106_y();
            } else if (item == SCContent.UNIVERSAL_BLOCK_REMOVER.get()) {
                this.func_70106_y();
                if (!player.func_184812_l_()) {
                    player.func_184614_ca().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(hand));
                }
            } else if (item == SCContent.DISGUISE_MODULE.get()) {
                ItemStack module = this.getDisguiseModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                    ArrayList<Block> blocks = ((ModuleItem)module.func_77973_b()).getBlockAddons(module.func_77978_p());
                    if (blocks.size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                        this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                    }
                }
                this.setDisguiseModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.WHITELIST_MODULE.get()) {
                ItemStack module = this.getWhitelistModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)module);
                }
                this.setWhitelistModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (item == SCContent.UNIVERSAL_BLOCK_MODIFIER.get()) {
                ArrayList<Block> blocks;
                if (!this.getDisguiseModule().func_190926_b() && (blocks = ((ModuleItem)this.getDisguiseModule().func_77973_b()).getBlockAddons(this.getDisguiseModule().func_77978_p())).size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                }
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getWhitelistModule());
                this.field_70180_af.func_187227_b(MODULE, (Object)new CompoundNBT());
                this.field_70180_af.func_187227_b(WHITELIST, (Object)new CompoundNBT());
            } else if (item == SCContent.REMOTE_ACCESS_SENTRY.get()) {
                item.func_195939_a(new ItemUseContext(player, hand, new BlockRayTraceResult(new Vector3d(0.0, 0.0, 0.0), Direction.NORTH, pos, false)));
            } else if (item == Items.field_151057_cb) {
                this.func_200203_b(player.func_184614_ca().func_200301_q());
                player.func_184614_ca().func_190918_g(1);
            } else if (item == SCContent.UNIVERSAL_OWNER_CHANGER.get()) {
                String newOwner;
                this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(newOwner, PlayerUtils.isPlayerOnline(newOwner = player.func_184614_ca().func_200301_q().getString()) ? PlayerUtils.getPlayerFromName(newOwner).func_110124_au().toString() : "ownerUUID"));
                if (this.field_70170_p.field_72995_K) {
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.UNIVERSAL_OWNER_CHANGER.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:universalOwnerChanger.changed", newOwner), TextFormatting.GREEN);
                }
            } else {
                this.toggleMode(player);
            }
            player.func_184609_a(Hand.MAIN_HAND);
            return ActionResultType.SUCCESS;
        }
        if (!this.getOwner().isOwner(player) && hand == Hand.MAIN_HAND && player.func_184812_l_() && (player.func_213453_ef() || player.func_184614_ca().func_77973_b() == SCContent.UNIVERSAL_BLOCK_REMOVER.get())) {
            this.func_70106_y();
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70106_y() {
        ArrayList<Block> blocks;
        BlockPos pos = this.func_233580_cy_();
        if (!this.getDisguiseModule().func_190926_b() && (blocks = ((ModuleItem)this.getDisguiseModule().func_77973_b()).getBlockAddons(this.getDisguiseModule().func_77978_p())).size() > 0 && blocks.get(0) == this.field_70170_p.func_180495_p(pos).func_177230_c()) {
            this.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        super.func_70106_y();
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)SCContent.SENTRY.get()));
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getDisguiseModule());
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)pos, (ItemStack)this.getWhitelistModule());
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void toggleMode(PlayerEntity player) {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE) + 1;
        if (mode >= 3) {
            mode = 0;
        }
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
        if (player.field_70170_p.field_72995_K) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.SENTRY.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:sentry.mode" + (mode + 1), new Object[0]).func_230529_a_((ITextComponent)ClientUtils.localize("messages.securitycraft:sentry.descriptionMode" + (mode + 1), new Object[0])), TextFormatting.DARK_RED);
        } else {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_233580_cy_(), true, mode == 0));
        }
    }

    public void toggleMode(PlayerEntity player, int mode, boolean sendMessage) {
        if (mode < 0 || mode > 2) {
            mode = 0;
        }
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
        if (player.field_70170_p.field_72995_K && sendMessage) {
            PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.SENTRY.get()).func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:sentry.mode" + (mode + 1), new Object[0]).func_230529_a_((ITextComponent)ClientUtils.localize("messages.securitycraft:sentry.descriptionMode" + (mode + 1), new Object[0])), TextFormatting.DARK_RED);
        } else if (!player.field_70170_p.field_72995_K) {
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_233580_cy_(), true, mode == 0));
        }
    }

    public void func_70624_b(LivingEntity target) {
        if (this.getMode() != SentryMode.AGGRESSIVE && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.func_145782_y())) {
            this.animateUpwards = this.getMode() == SentryMode.CAMOUFLAGE && target != null;
            this.animate = true;
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_233580_cy_(), this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.func_145782_y();
        super.func_70624_b(target);
    }

    public float func_213307_e(Pose pose) {
        return 1.5f;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (target instanceof PlayerEntity && (((PlayerEntity)target).func_175149_v() || ((PlayerEntity)target).func_184812_l_())) {
            return;
        }
        if (this.func_70068_e((Entity)target) > 400.0) {
            return;
        }
        BulletEntity throwableEntity = new BulletEntity(this.field_70170_p, (LivingEntity)this);
        double y = target.func_226278_cu_() + (double)target.func_70047_e() - (double)1.1f;
        double x = target.func_226277_ct_() - this.func_226277_ct_();
        double d2 = y - throwableEntity.func_226278_cu_();
        double z = target.func_226281_cx_() - this.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.2f;
        throwableEntity.func_226288_n_(throwableEntity.func_226277_ct_(), throwableEntity.func_226278_cu_() - (double)0.1f, throwableEntity.func_226281_cx_());
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf((float)(MathHelper.func_181159_b((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.func_70186_c(x, d2 + (double)f, z, 1.6f, 0.0f);
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_217376_c((Entity)throwableEntity);
    }

    public void func_213281_b(CompoundNBT tag) {
        tag.func_218657_a("TileEntityData", (INBT)this.getOwnerTag());
        tag.func_218657_a("InstalledModule", (INBT)this.getDisguiseModule().func_77955_b(new CompoundNBT()));
        tag.func_218657_a("InstalledWhitelist", (INBT)this.getWhitelistModule().func_77955_b(new CompoundNBT()));
        tag.func_74768_a("SentryMode", ((Integer)this.field_70180_af.func_187225_a(MODE)).intValue());
        tag.func_74776_a("HeadRotation", ((Float)this.field_70180_af.func_187225_a(HEAD_ROTATION)).floatValue());
        super.func_213281_b(tag);
    }

    private CompoundNBT getOwnerTag() {
        CompoundNBT tag = new CompoundNBT();
        Owner owner = (Owner)this.field_70180_af.func_187225_a(OWNER);
        tag.func_74778_a("owner", owner.getName());
        tag.func_74778_a("ownerUUID", owner.getUUID());
        return tag;
    }

    public void func_70037_a(CompoundNBT tag) {
        CompoundNBT teTag = tag.func_74775_l("TileEntityData");
        String name = teTag.func_74779_i("owner");
        String uuid = teTag.func_74779_i("ownerUUID");
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(name, uuid));
        this.field_70180_af.func_187227_b(MODULE, (Object)tag.func_74775_l("InstalledModule"));
        this.field_70180_af.func_187227_b(WHITELIST, (Object)tag.func_74775_l("InstalledWhitelist"));
        this.field_70180_af.func_187227_b(MODE, (Object)tag.func_74762_e("SentryMode"));
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(tag.func_74760_g("HeadRotation")));
        super.func_70037_a(tag);
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setDisguiseModule(ItemStack module) {
        ArrayList<ItemStack> blocks = ((ModuleItem)module.func_77973_b()).getAddons(module.func_77978_p());
        if (blocks.size() > 0) {
            ItemStack disguiseStack = (ItemStack)blocks.get(0);
            BlockState state = Block.func_149634_a((Item)disguiseStack.func_77973_b()).func_176223_P();
            if (this.field_70170_p.func_180495_p(this.func_233580_cy_()).isAir((IBlockReader)this.field_70170_p, this.func_233580_cy_())) {
                this.field_70170_p.func_175656_a(this.func_233580_cy_(), state.func_196954_c((IBlockReader)this.field_70170_p, this.func_233580_cy_()) == VoxelShapes.func_197868_b() ? state : Blocks.field_150350_a.func_176223_P());
            }
        }
        this.field_70180_af.func_187227_b(MODULE, (Object)module.func_77955_b(new CompoundNBT()));
    }

    public void setWhitelistModule(ItemStack module) {
        this.field_70180_af.func_187227_b(WHITELIST, (Object)module.func_77955_b(new CompoundNBT()));
    }

    public ItemStack getDisguiseModule() {
        CompoundNBT tag = (CompoundNBT)this.field_70180_af.func_187225_a(MODULE);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)tag);
    }

    public ItemStack getWhitelistModule() {
        CompoundNBT tag = (CompoundNBT)this.field_70180_af.func_187225_a(WHITELIST);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((CompoundNBT)tag);
    }

    public SentryMode getMode() {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE);
        return mode < 0 || mode > 2 ? SentryMode.CAMOUFLAGE : SentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean isTargetingWhitelistedPlayer(LivingEntity potentialTarget) {
        if (potentialTarget != null) {
            List<String> players = ModuleUtils.getPlayersFromModule(this.getWhitelistModule());
            for (String s : players) {
                if (!potentialTarget.func_200200_C_().func_150261_e().equalsIgnoreCase(s)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return false;
    }

    public void func_70664_aZ() {
    }

    public boolean func_70781_l() {
        return false;
    }

    public void func_70623_bb() {
    }

    public boolean func_213397_c(double distanceClosestToPlayer) {
        return false;
    }

    public void func_70100_b_(PlayerEntity entity) {
    }

    public void func_213315_a(MoverType type, Vector3d vec) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void func_110159_bB() {
    }

    public Random func_70681_au() {
        return notRandom;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum SentryMode {
        AGGRESSIVE,
        CAMOUFLAGE,
        IDLE;

    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

