/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidAttributes;

public abstract class FakeLavaFluid
extends FlowingFluid {
    public Fluid func_210197_e() {
        return (Fluid)SCContent.FLOWING_FAKE_LAVA.get();
    }

    public Fluid func_210198_f() {
        return (Fluid)SCContent.FAKE_LAVA.get();
    }

    public Item func_204524_b() {
        return (Item)SCContent.FAKE_LAVA_BUCKET.get();
    }

    protected FluidAttributes createAttributes() {
        return FluidAttributes.builder((ResourceLocation)new ResourceLocation("block/lava_still"), (ResourceLocation)new ResourceLocation("block/lava_flow")).translationKey("block.minecraft.lava").luminosity(15).density(3000).viscosity(6000).temperature(1300).build((Fluid)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World world, BlockPos pos, FluidState state, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (world.func_180495_p(blockpos).func_196958_f() && !world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) {
            if (random.nextInt(100) == 0) {
                double x = (float)pos.func_177958_n() + random.nextFloat();
                double y = pos.func_177956_o() + 1;
                double z = (float)pos.func_177952_p() + random.nextFloat();
                world.func_195594_a((IParticleData)ParticleTypes.field_197595_F, x, y, z, 0.0, 0.0, 0.0);
                world.func_184134_a(x, y, z, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void func_207186_b(World world, BlockPos pos, FluidState state, Random random) {
        block7: {
            if (!world.func_82736_K().func_223586_b(GameRules.field_223598_a)) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.func_195588_v(blockpos = blockpos.func_177982_a(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    BlockState blockState = world.func_180495_p(blockpos);
                    if (blockState.func_196958_f()) {
                        if (!this.isSurroundingBlockFlammable((IWorldReader)world, blockpos)) continue;
                        world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!blockState.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.func_195588_v(blockpos1)) {
                        return;
                    }
                    if (!world.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn((IWorldReader)world, blockpos1)) continue;
                    world.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(IWorldReader world, BlockPos pos) {
        for (Direction Direction2 : Direction.values()) {
            if (!this.getCanBlockBurn(world, pos.func_177972_a(Direction2))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(IWorldReader world, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !world.func_175667_e(pos) ? false : world.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197617_j;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, BlockState state) {
        this.triggerEffects(world, pos);
    }

    public int func_185698_b(IWorldReader world) {
        return world.func_230315_m_().func_236040_e_() ? 4 : 2;
    }

    public BlockState func_204527_a(FluidState state) {
        return (BlockState)((Block)SCContent.FAKE_LAVA_BLOCK.get()).func_176223_P().func_206870_a((Property)FlowingFluidBlock.field_176367_b, (Comparable)Integer.valueOf(FakeLavaFluid.func_207205_e((FluidState)state)));
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid == SCContent.FAKE_LAVA.get() || fluid == SCContent.FLOWING_FAKE_LAVA.get();
    }

    public int func_204528_b(IWorldReader world) {
        return world.func_230315_m_().func_236040_e_() ? 1 : 2;
    }

    public boolean func_215665_a(FluidState fluidState, IBlockReader world, BlockPos pos, Fluid fluid, Direction dir) {
        return fluidState.func_215679_a(world, pos) >= 0.44444445f && fluid.func_207185_a((ITag)FluidTags.field_206959_a);
    }

    public int func_205569_a(IWorldReader world) {
        return world.func_230315_m_().func_236040_e_() ? 10 : 30;
    }

    public int func_215667_a(World world, BlockPos pos, FluidState fluidState1, FluidState fluidState2) {
        int i = this.func_205569_a((IWorldReader)world);
        if (!(fluidState1.func_206888_e() || fluidState2.func_206888_e() || ((Boolean)fluidState1.func_177229_b((Property)field_207209_a)).booleanValue() || ((Boolean)fluidState2.func_177229_b((Property)field_207209_a)).booleanValue() || !(fluidState2.func_215679_a((IBlockReader)world, pos) > fluidState1.func_215679_a((IBlockReader)world, pos)) || world.func_201674_k().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    protected void triggerEffects(IWorld world, BlockPos pos) {
        world.func_217379_c(1501, pos, 0);
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205574_a(IWorld world, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState) {
        if (direction == Direction.DOWN) {
            FluidState ifluidstate = world.func_204610_c(pos);
            if (this.func_207185_a((ITag)FluidTags.field_206960_b) && ifluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
                    world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 3);
                }
                this.triggerEffects(world, pos);
                return;
            }
        }
        super.func_205574_a(world, pos, blockState, direction, fluidState);
    }

    protected boolean func_207196_h() {
        return true;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public int func_207192_d(FluidState state) {
            return 8;
        }

        public boolean func_207193_c(FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, FluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new Property[]{field_207210_b});
        }

        public int func_207192_d(FluidState state) {
            return (Integer)state.func_177229_b((Property)field_207210_b);
        }

        public boolean func_207193_c(FluidState state) {
            return false;
        }
    }
}

