/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.DisguiseModuleContainer;
import net.geforcemods.securitycraft.containers.ModuleItemInventory;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ModuleItem
extends Item {
    public static final Style GRAY_STYLE = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
    public static final int MAX_PLAYERS = 50;
    private final ModuleType module;
    private final boolean nbtCanBeModified;
    private boolean canBeCustomized;
    private int numberOfItemAddons;
    private int numberOfBlockAddons;

    public ModuleItem(ModuleType module, boolean nbtCanBeModified) {
        this(module, nbtCanBeModified, false, 0, 0);
    }

    public ModuleItem(ModuleType module, boolean nbtCanBeModified, boolean canBeCustomized) {
        this(module, nbtCanBeModified, canBeCustomized, 0, 0);
    }

    public ModuleItem(ModuleType module, boolean nbtCanBeModified, boolean canBeCustomized, int itemAddons, int blockAddons) {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).func_200917_a(1));
        this.module = module;
        this.nbtCanBeModified = nbtCanBeModified;
        this.canBeCustomized = canBeCustomized;
        this.numberOfItemAddons = itemAddons;
        this.numberOfBlockAddons = blockAddons;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, final Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        try {
            if (this.canBeCustomized()) {
                if (world.field_72995_K && (this.module == ModuleType.WHITELIST || this.module == ModuleType.BLACKLIST)) {
                    SecurityCraft.proxy.displayEditModuleGui(stack);
                } else if (!world.field_72995_K && this.module == ModuleType.DISGUISE) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                        public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
                            return new DisguiseModuleContainer(windowId, inv, new ModuleItemInventory(player.func_184586_b(hand)));
                        }

                        public ITextComponent func_145748_c_() {
                            return new TranslationTextComponent(ModuleItem.this.func_77658_a());
                        }
                    });
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.nbtCanBeModified || this.canBeCustomized()) {
            list.add((ITextComponent)new TranslationTextComponent("tooltip.securitycraft:module.modifiable").func_230530_a_(GRAY_STYLE));
        } else {
            list.add((ITextComponent)new TranslationTextComponent("tooltip.securitycraft:module.notModifiable").func_230530_a_(GRAY_STYLE));
        }
        if (this.nbtCanBeModified && stack.func_77978_p() != null && !stack.func_77978_p().isEmpty()) {
            list.add(StringTextComponent.field_240750_d_);
            list.add((ITextComponent)new TranslationTextComponent("tooltip.securitycraft:module.playerCustomization.players").func_230530_a_(GRAY_STYLE));
            for (int i = 1; i <= 50; ++i) {
                if (stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                list.add((ITextComponent)new StringTextComponent(stack.func_77978_p().func_74779_i("Player" + i)).func_230530_a_(GRAY_STYLE));
            }
        }
        if (this.canBeCustomized()) {
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons > 0) {
                list.add((ITextComponent)ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.blocksAndItems", this.numberOfBlockAddons, this.numberOfItemAddons).func_230530_a_(GRAY_STYLE));
            }
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons == 0) {
                list.add((ITextComponent)ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.items", this.numberOfItemAddons).func_230530_a_(GRAY_STYLE));
            }
            if (this.numberOfItemAddons == 0 && this.numberOfBlockAddons > 0) {
                list.add((ITextComponent)ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.blocks", this.numberOfBlockAddons).func_230530_a_(GRAY_STYLE));
            }
            if (this.getNumberOfAddons() > 0 && !this.getAddons(stack.func_77978_p()).isEmpty()) {
                list.add(StringTextComponent.field_240750_d_);
                list.add((ITextComponent)ClientUtils.localize("tooltip.securitycraft:module.itemAddons.added", new Object[0]).func_230530_a_(GRAY_STYLE));
                for (ItemStack addon : this.getAddons(stack.func_77978_p())) {
                    list.add((ITextComponent)new StringTextComponent("- ").func_230529_a_((ITextComponent)ClientUtils.localize(addon.func_77977_a(), new Object[0])).func_230530_a_(GRAY_STYLE));
                }
            }
        }
    }

    public ModuleType getModule() {
        return this.module;
    }

    public int getNumberOfAddons() {
        return this.numberOfItemAddons + this.numberOfBlockAddons;
    }

    public int getNumberOfItemAddons() {
        return this.numberOfItemAddons;
    }

    public int getNumberOfBlockAddons() {
        return this.numberOfBlockAddons;
    }

    public ArrayList<Block> getBlockAddons(CompoundNBT tag) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (tag == null) {
            return list;
        }
        ListNBT items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack;
            CompoundNBT item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons || !((stack = ItemStack.func_199557_a((CompoundNBT)item)).func_77973_b() instanceof BlockItem)) continue;
            list.add(Block.func_149634_a((Item)stack.func_77973_b()));
        }
        return list;
    }

    public ArrayList<ItemStack> getAddons(CompoundNBT tag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (tag == null) {
            return list;
        }
        ListNBT items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            CompoundNBT item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons) continue;
            list.add(ItemStack.func_199557_a((CompoundNBT)item));
        }
        return list;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

