/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ScannerDoorItem
extends Item {
    public ScannerDoorItem() {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCDecoration));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c, ctx);
    }

    public ActionResultType onItemUse(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ, ItemUseContext ctx) {
        if (world.field_72995_K) {
            return ActionResultType.FAIL;
        }
        if (facing != Direction.UP) {
            return ActionResultType.FAIL;
        }
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_196253_a(world.func_180495_p(pos), new BlockItemUseContext(ctx))) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, stack) && BlockUtils.isSideSolid((IWorldReader)world, pos.func_177977_b(), Direction.UP)) {
            Direction angleFacing = Direction.func_176733_a((double)player.field_70177_z);
            int offsetX = angleFacing.func_82601_c();
            int offsetZ = angleFacing.func_82599_e();
            boolean flag = offsetX < 0 && hitZ < 0.5 || offsetX > 0 && hitZ > 0.5 || offsetZ < 0 && hitX > 0.5 || offsetZ > 0 && hitX < 0.5;
            ScannerDoorItem.placeDoor(world, pos, angleFacing, (Block)SCContent.SCANNER_DOOR.get(), flag);
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(null, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            if (world.func_175625_s(pos) != null) {
                CustomizableTileEntity lowerTe = (CustomizableTileEntity)world.func_175625_s(pos);
                CustomizableTileEntity upperTe = (CustomizableTileEntity)world.func_175625_s(pos.func_177984_a());
                lowerTe.getOwner().set(player.func_146103_bH().getId().toString(), player.func_200200_C_());
                upperTe.getOwner().set(player.func_146103_bH().getId().toString(), player.func_200200_C_());
                CustomizableTileEntity.link(lowerTe, upperTe);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public static void placeDoor(World world, BlockPos pos, Direction facing, Block door, boolean isRightHinge) {
        boolean isLeftDoor;
        BlockPos left = pos.func_177972_a(facing.func_176746_e());
        BlockPos right = pos.func_177972_a(facing.func_176735_f());
        int rightNormalCubeAmount = (world.func_180495_p(right).func_215686_e((IBlockReader)world, pos) ? 1 : 0) + (world.func_180495_p(right.func_177984_a()).func_215686_e((IBlockReader)world, pos) ? 1 : 0);
        int leftNormalCubeAmount = (world.func_180495_p(left).func_215686_e((IBlockReader)world, pos) ? 1 : 0) + (world.func_180495_p(left.func_177984_a()).func_215686_e((IBlockReader)world, pos) ? 1 : 0);
        boolean isRightDoor = world.func_180495_p(right).func_177230_c() == door || world.func_180495_p(right.func_177984_a()).func_177230_c() == door;
        boolean bl = isLeftDoor = world.func_180495_p(left).func_177230_c() == door || world.func_180495_p(left.func_177984_a()).func_177230_c() == door;
        if ((!isRightDoor || isLeftDoor) && leftNormalCubeAmount <= rightNormalCubeAmount) {
            if (isLeftDoor && !isRightDoor || leftNormalCubeAmount < rightNormalCubeAmount) {
                isRightHinge = false;
            }
        } else {
            isRightHinge = true;
        }
        BlockPos blockAbove = pos.func_177984_a();
        boolean isAnyPowered = world.func_175640_z(pos) || world.func_175640_z(blockAbove);
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)door.func_176223_P().func_206870_a((Property)DoorBlock.field_176520_a, (Comparable)facing)).func_206870_a((Property)DoorBlock.field_176521_M, (Comparable)(isRightHinge ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT))).func_206870_a((Property)DoorBlock.field_176522_N, (Comparable)Boolean.valueOf(isAnyPowered))).func_206870_a((Property)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf(isAnyPowered));
        world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER), 2);
        world.func_180501_a(blockAbove, (BlockState)state.func_206870_a((Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.UPPER), 2);
        world.func_195593_d(pos, door);
        world.func_195593_d(blockAbove, door);
    }
}

