/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.SentryEntity;
import net.geforcemods.securitycraft.network.client.OpenSRATGui;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class SentryRemoteAccessToolItem
extends Item {
    public SentryRemoteAccessToolItem() {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OpenSRATGui((player.func_184102_h().func_184103_al().func_72395_o() - 1) * 16));
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_221532_j().field_72450_a, ctx.func_221532_j().field_72448_b, ctx.func_221532_j().field_72449_c);
    }

    public ActionResultType onItemUse(PlayerEntity player, World world, BlockPos pos, ItemStack stack, Direction facing, double hitX, double hitY, double hitZ) {
        List sentries = world.func_217357_a(SentryEntity.class, new AxisAlignedBB(pos));
        if (!world.field_72995_K) {
            if (!sentries.isEmpty()) {
                SentryEntity sentry = (SentryEntity)((Object)sentries.get(0));
                BlockPos pos2 = sentry.func_233580_cy_();
                if (!this.isSentryAdded(stack, pos2)) {
                    int availSlot = this.getNextAvaliableSlot(stack);
                    if (availSlot == 0) {
                        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:srat.noSlots", new Object[0]), TextFormatting.RED);
                        return ActionResultType.FAIL;
                    }
                    if (!sentry.getOwner().isOwner(player)) {
                        PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:srat.cantBind", new Object[0]), TextFormatting.RED);
                        return ActionResultType.FAIL;
                    }
                    if (stack.func_77978_p() == null) {
                        stack.func_77982_d(new CompoundNBT());
                    }
                    stack.func_77978_p().func_74783_a("sentry" + availSlot, BlockUtils.fromPos(pos2));
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:srat.bound", pos2), TextFormatting.GREEN);
                } else {
                    this.removeTagFromItemAndUpdate(stack, pos2, player);
                    PlayerUtils.sendMessageToPlayer(player, (IFormattableTextComponent)ClientUtils.localize(((Item)SCContent.REMOTE_ACCESS_SENTRY.get()).func_77658_a(), new Object[0]), (IFormattableTextComponent)ClientUtils.localize("messages.securitycraft:srat.unbound", pos2), TextFormatting.RED);
                }
            } else {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new OpenSRATGui((player.func_184102_h().func_184103_al().func_72395_o() - 1) * 16));
            }
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            if (stack.func_77978_p().func_74759_k("sentry" + i).length > 0) {
                int[] coords = stack.func_77978_p().func_74759_k("sentry" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "---"));
                    continue;
                }
                BlockPos pos = new BlockPos(coords[0], coords[1], coords[2]);
                List sentries = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_217357_a(SentryEntity.class, new AxisAlignedBB(pos));
                String nameToShow = !sentries.isEmpty() && ((SentryEntity)((Object)sentries.get(0))).func_145818_k_() ? ((SentryEntity)((Object)sentries.get(0))).func_200201_e().getString() : ClientUtils.localize("tooltip.securitycraft:sentry", new Object[0]) + " " + i;
                tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + nameToShow + ": " + Utils.getFormattedCoordinates(pos)));
                continue;
            }
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.GRAY + "---"));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, PlayerEntity player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("sentry" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new UpdateNBTTagOnClient(stack));
            return;
        }
    }

    private boolean isSentryAdded(ItemStack stack, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 12; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("sentry" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("sentry" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvaliableSlot(ItemStack stack) {
        for (int i = 1; i <= 12; ++i) {
            if (stack.func_77978_p() == null) {
                return 1;
            }
            if (stack.func_77978_p().func_74759_k("sentry" + i).length != 0 && (stack.func_77978_p().func_74759_k("sentry" + i)[0] != 0 || stack.func_77978_p().func_74759_k("sentry" + i)[1] != 0 || stack.func_77978_p().func_74759_k("sentry" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

