/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraftforge.fml.network.NetworkEvent;

public class GivePotionEffect {
    private int potionID;
    private int duration;
    private int amplifier;

    public GivePotionEffect() {
    }

    public GivePotionEffect(int potionID, int duration, int amplifier) {
        this.potionID = potionID;
        this.duration = duration;
        this.amplifier = amplifier;
    }

    public void fromBytes(ByteBuf buf) {
        this.potionID = buf.readInt();
        this.duration = buf.readInt();
        this.amplifier = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.potionID);
        buf.writeInt(this.duration);
        buf.writeInt(this.amplifier);
    }

    public static void encode(GivePotionEffect message, PacketBuffer packet) {
        message.toBytes((ByteBuf)packet);
    }

    public static GivePotionEffect decode(PacketBuffer packet) {
        GivePotionEffect message = new GivePotionEffect();
        message.fromBytes((ByteBuf)packet);
        return message;
    }

    public static void onMessage(GivePotionEffect message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ((NetworkEvent.Context)ctx.get()).getSender().func_195064_c(new EffectInstance(Effect.func_188412_a((int)message.potionID), message.duration, message.amplifier, false, true)));
        ctx.get().setPacketHandled(true);
    }
}

