/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class MountCamera {
    private int x;
    private int y;
    private int z;
    private int id;

    public MountCamera() {
    }

    public MountCamera(int x, int y, int z, int id) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.id = id;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.id);
    }

    public void fromBytes(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.id = buf.readInt();
    }

    public static void encode(MountCamera message, PacketBuffer packet) {
        message.toBytes((ByteBuf)packet);
    }

    public static MountCamera decode(PacketBuffer packet) {
        MountCamera message = new MountCamera();
        message.fromBytes((ByteBuf)packet);
        return message;
    }

    public static void onMessage(MountCamera message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            int x = message.x;
            int y = message.y;
            int z = message.z;
            int id = message.id;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            if (BlockUtils.getBlock((IBlockReader)world, BlockUtils.toPos(x, y, z)) instanceof SecurityCameraBlock) {
                ((SecurityCameraBlock)BlockUtils.getBlock(world, x, y, z)).mountCamera(world, x, y, z, id, (PlayerEntity)player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

