/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.OwnableTileEntity;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.SecurityCameraBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetCameraPowered {
    private BlockPos pos;
    private boolean powered;

    public SetCameraPowered() {
    }

    public SetCameraPowered(BlockPos pos, boolean powered) {
        this.pos = pos;
        this.powered = powered;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeBoolean(this.powered);
    }

    public void fromBytes(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.powered = buf.readBoolean();
    }

    public static void encode(SetCameraPowered message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SetCameraPowered decode(PacketBuffer packet) {
        SetCameraPowered message = new SetCameraPowered();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(SetCameraPowered message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            TileEntity te = world.func_175625_s(pos);
            CompoundNBT modules = ((IModuleInventory)te).writeModuleInventory(new CompoundNBT());
            Owner owner = ((OwnableTileEntity)te).getOwner();
            world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)SecurityCameraBlock.POWERED, (Comparable)Boolean.valueOf(message.powered)));
            ((IModuleInventory)te).readModuleInventory(modules);
            ((OwnableTileEntity)te).getOwner().set(owner.getUUID(), owner.getName());
            world.func_195593_d(pos.func_177967_a((Direction)world.func_180495_p(pos).func_177229_b((Property)SecurityCameraBlock.FACING), -1), world.func_180495_p(pos).func_177230_c());
        });
        ctx.get().setPacketHandled(true);
    }
}

