/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.tileentity.IMSTileEntity;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class IMSScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private final TranslationTextComponent imsName = ClientUtils.localize(((Block)SCContent.IMS.get()).func_149739_a(), new Object[0]);
    private final TranslationTextComponent target = ClientUtils.localize("gui.securitycraft:ims.target", new Object[0]);
    private IMSTileEntity tileEntity;
    private ClickButton targetButton;
    private int targetingOptionIndex = 0;

    public IMSScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = (IMSTileEntity)container.te;
        this.targetingOptionIndex = this.tileEntity.getTargetingOption().modeIndex;
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.targetButton = new ClickButton(0, this.field_230708_k_ / 2 - 38, this.field_230709_l_ / 2 - 58, 120, 20, (ITextComponent)(this.tileEntity.getTargetingOption() == IMSTileEntity.IMSTargetingMode.PLAYERS_AND_MOBS ? ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]) : ClientUtils.localize("tooltip.securitycraft:module.players", new Object[0])), this::actionPerformed);
        this.func_230480_a_((Widget)this.targetButton);
        this.updateButtonText();
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.imsName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.imsName) / 2), 6.0f, 0x404040);
        this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.target, (float)(this.field_146999_f / 2 - 78), 30.0f, 0x404040);
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 0) {
            ++this.targetingOptionIndex;
            if (this.targetingOptionIndex > IMSTileEntity.IMSTargetingMode.values().length - 1) {
                this.targetingOptionIndex = 0;
            }
            this.tileEntity.setTargetingOption(IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex]);
            ClientUtils.syncTileEntity(this.tileEntity);
            this.updateButtonText();
        }
    }

    private void updateButtonText() {
        if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.PLAYERS) {
            this.targetButton.func_238482_a_((ITextComponent)ClientUtils.localize("tooltip.securitycraft:module.playerCustomization.players", new Object[0]));
        } else if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.PLAYERS_AND_MOBS) {
            this.targetButton.func_238482_a_((ITextComponent)ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]));
        } else if (IMSTileEntity.IMSTargetingMode.values()[this.targetingOptionIndex] == IMSTileEntity.IMSTargetingMode.MOBS) {
            this.targetButton.func_238482_a_((ITextComponent)ClientUtils.localize("gui.securitycraft:ims.hostile", new Object[0]));
        }
    }
}

