/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.containers.GenericTEContainer;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.screen.components.ClickButton;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class SetPasswordScreen
extends ContainerScreen<GenericTEContainer> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntity tileEntity;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private TranslationTextComponent blockName;
    private TranslationTextComponent setup;
    private IFormattableTextComponent combined;
    private TextFieldWidget keycodeTextbox;
    private boolean isInvalid = false;
    private ClickButton saveAndContinueButton;

    public SetPasswordScreen(GenericTEContainer container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
        this.tileEntity = container.te;
        this.blockName = ClientUtils.localize(this.tileEntity.func_195044_w().func_177230_c().func_149739_a(), new Object[0]);
        this.setup = ClientUtils.localize("gui.securitycraft:password.setup", new Object[0]);
        this.combined = this.blockName.func_230531_f_().func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)this.setup);
    }

    public void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.saveAndContinueButton = new ClickButton(0, this.field_230708_k_ / 2 - 48, this.field_230709_l_ / 2 + 30 + 10, 100, 20, (ITextComponent)(!this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0])), this::actionPerformed);
        this.func_230480_a_((Widget)this.saveAndContinueButton);
        this.keycodeTextbox = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 37, this.field_230709_l_ / 2 - 47, 77, 12, StringTextComponent.field_240750_d_);
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(11);
        this.keycodeTextbox.func_146195_b(true);
        this.updateButtonText();
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        this.isInvalid = false;
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        RenderSystem.disableLighting();
        this.keycodeTextbox.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        this.func_238476_c_(matrix, this.field_230712_o_, "CODE:", this.field_230708_k_ / 2 - 67, this.field_230709_l_ / 2 - 47 + 2, 0x404040);
    }

    protected void func_230451_b_(MatrixStack matrix, int mouseX, int mouseY) {
        if (this.field_230712_o_.func_238414_a_((ITextProperties)this.combined) < this.field_146999_f - 10) {
            this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.combined, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.combined) / 2), 6.0f, 0x404040);
        } else {
            this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.blockName, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.blockName) / 2), 6.0f, 0x404040);
            this.field_230712_o_.func_238422_b_(matrix, (ITextProperties)this.setup, (float)(this.field_146999_f / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)this.setup) / 2), 16.0f, 0x404040);
        }
    }

    protected void func_230450_a_(MatrixStack matrix, float partialTicks, int mouseX, int mouseY) {
        this.func_230446_a_(matrix);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_230708_k_ - this.field_146999_f) / 2;
        int startY = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrix, startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && this.keycodeTextbox.func_146179_b().length() > 0) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("random.click")), 0.15f, 1.0f);
            this.keycodeTextbox.func_146180_a(this.keycodeTextbox.func_146179_b().substring(0, this.keycodeTextbox.func_146179_b().length() - 1));
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231042_a_(char typedChar, int keyCode) {
        if (this.keycodeTextbox.func_230999_j_() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.func_231042_a_(typedChar, keyCode);
            return true;
        }
        return super.func_231042_a_(typedChar, keyCode);
    }

    private boolean isValidChar(char c) {
        for (int i = 0; i < this.allowedChars.length; ++i) {
            if (c != this.allowedChars[i]) continue;
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.keycodeTextbox.func_231044_a_(mouseX, mouseY, mouseButton);
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    private void updateButtonText() {
        this.saveAndContinueButton.func_238482_a_((ITextComponent)(!this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0])));
    }

    protected void actionPerformed(ClickButton button) {
        if (button.id == 0) {
            if (this.keycodeTextbox.func_146179_b().isEmpty()) {
                this.isInvalid = true;
                this.updateButtonText();
                return;
            }
            ((IPasswordProtected)this.tileEntity).setPassword(this.keycodeTextbox.func_146179_b());
            SecurityCraft.channel.sendToServer((Object)new SetPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.keycodeTextbox.func_146179_b()));
            ClientUtils.closePlayerScreen();
        }
    }
}

