/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.SecurityCraftTileEntity;
import net.geforcemods.securitycraft.blocks.mines.ClaymoreBlock;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;

public class ClaymoreTileEntity
extends SecurityCraftTileEntity {
    private double entityX = -1.0;
    private double entityY = -1.0;
    private double entityZ = -1.0;
    private int cooldown = -1;

    public ClaymoreTileEntity() {
        super(SCContent.teTypeClaymore);
    }

    @Override
    public void func_73660_a() {
        if (!this.func_145831_w().field_72995_K) {
            if (((Boolean)this.func_145831_w().func_180495_p(this.func_174877_v()).func_177229_b((Property)ClaymoreBlock.DEACTIVATED)).booleanValue()) {
                return;
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                return;
            }
            if (this.cooldown == 0) {
                this.func_145831_w().func_175655_b(this.func_174877_v(), false);
                this.func_145831_w().func_217398_a((Entity)null, this.entityX, this.entityY + 0.5, this.entityZ, 3.5f, true, Explosion.Mode.BREAK);
                return;
            }
            Direction dir = (Direction)BlockUtils.getBlockProperty(this.func_145831_w(), this.func_174877_v(), ClaymoreBlock.FACING);
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1);
            if (dir == Direction.NORTH) {
                area = area.func_191195_a(0.0, 0.0, (double)((Integer)ConfigHandler.CONFIG.claymoreRange.get()).intValue());
            } else if (dir == Direction.SOUTH) {
                area = area.func_191195_a(0.0, 0.0, (double)(-((Integer)ConfigHandler.CONFIG.claymoreRange.get()).intValue()));
            } else if (dir == Direction.EAST) {
                area = area.func_191195_a((double)(-((Integer)ConfigHandler.CONFIG.claymoreRange.get()).intValue()), 0.0, 0.0);
            } else if (dir == Direction.WEST) {
                area = area.func_191195_a((double)((Integer)ConfigHandler.CONFIG.claymoreRange.get()).intValue(), 0.0, 0.0);
            }
            List entities = this.func_145831_w().func_175647_a(LivingEntity.class, area, e -> !EntityUtils.isInvisible(e));
            for (LivingEntity entity : entities) {
                if (PlayerUtils.isPlayerMountedOnCamera(entity) || EntityUtils.doesEntityOwn((Entity)entity, this.field_145850_b, this.field_174879_c)) continue;
                this.entityX = entity.func_226277_ct_();
                this.entityY = entity.func_226278_cu_();
                this.entityZ = entity.func_226281_cx_();
                this.cooldown = 20;
                this.func_145831_w().func_184133_a(null, new BlockPos((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5), SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
                break;
            }
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("cooldown", this.cooldown);
        tag.func_74780_a("entityX", this.entityX);
        tag.func_74780_a("entityY", this.entityY);
        tag.func_74780_a("entityZ", this.entityZ);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("cooldown")) {
            this.cooldown = tag.func_74762_e("cooldown");
        }
        if (tag.func_74764_b("entityX")) {
            this.entityX = tag.func_74769_h("entityX");
        }
        if (tag.func_74764_b("entityY")) {
            this.entityY = tag.func_74769_h("entityY");
        }
        if (tag.func_74764_b("entityZ")) {
            this.entityZ = tag.func_74769_h("entityZ");
        }
    }
}

