/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.LinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.LaserBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.tileentity.DisguisableTileEntity;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class LaserBlockTileEntity
extends DisguisableTileEntity {
    private Option.BooleanOption enabledOption = new Option.BooleanOption("enabled", true){

        @Override
        public void toggle() {
            this.setValue((Boolean)this.get() == false);
            LaserBlockTileEntity.this.toggleLaser(this);
        }
    };

    public LaserBlockTileEntity() {
        super(SCContent.teTypeLaserBlock);
    }

    private void toggleLaser(Option.BooleanOption option) {
        if (BlockUtils.getBlock((IBlockReader)this.field_145850_b, this.field_174879_c) != SCContent.LASER_BLOCK.get()) {
            return;
        }
        if (((Boolean)option.get()).booleanValue()) {
            ((LaserBlock)BlockUtils.getBlock((IBlockReader)this.field_145850_b, this.field_174879_c)).setLaser(this.field_145850_b, this.field_174879_c);
        } else {
            LaserBlock.destroyAdjacentLasers((IWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(LinkedAction action, Object[] parameters, ArrayList<CustomizableTileEntity> excludedTEs) {
        if (action == LinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.BooleanOption)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == LinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == LinkedAction.MODULE_REMOVED) {
            ModuleType module = (ModuleType)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(LinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.HARMING, ModuleType.WHITELIST, ModuleType.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public boolean isEnabled() {
        return (Boolean)this.enabledOption.get();
    }
}

