/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableTileEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.PortableRadarBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class PortableRadarTileEntity
extends CustomizableTileEntity {
    private Option.DoubleOption searchRadiusOption;
    private Option.IntOption searchDelayOption;
    private Option.BooleanOption repeatMessageOption;
    private Option.BooleanOption enabledOption;
    private boolean shouldSendNewMessage;
    private String lastPlayerName;

    public PortableRadarTileEntity() {
        super(SCContent.teTypePortableRadar);
        this.searchRadiusOption = new Option.DoubleOption("searchRadius", (Double)ConfigHandler.CONFIG.portableRadarSearchRadius.get(), 5.0, 50.0, 5.0);
        this.searchDelayOption = new Option.IntOption("searchDelay", (Integer)ConfigHandler.CONFIG.portableRadarDelay.get(), 4, 10, 1);
        this.repeatMessageOption = new Option.BooleanOption("repeatMessage", true);
        this.enabledOption = new Option.BooleanOption("enabled", true);
        this.shouldSendNewMessage = true;
        this.lastPlayerName = "";
    }

    @Override
    public boolean attackEntity(Entity attacked) {
        if (attacked instanceof PlayerEntity && !EntityUtils.isInvisible((LivingEntity)((PlayerEntity)attacked))) {
            boolean redstoneModule;
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
            List entities = this.field_145850_b.func_217357_a(this.entityTypeToAttack(), area);
            if (entities.isEmpty() && (!(redstoneModule = this.hasModule(ModuleType.REDSTONE)) || ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((Property)PortableRadarBlock.POWERED)).booleanValue())) {
                PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
                return false;
            }
            ServerPlayerEntity owner = this.field_145850_b.func_73046_m().func_184103_al().func_152612_a(this.getOwner().getName());
            if (owner != null && this.hasModule(ModuleType.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, ModuleType.WHITELIST).contains(attacked.func_200200_C_().getString().toLowerCase())) {
                return false;
            }
            if (PlayerUtils.isPlayerOnline(this.getOwner().getName()) && this.shouldSendMessage((PlayerEntity)attacked)) {
                IFormattableTextComponent attackedName = attacked.func_200200_C_().func_230531_f_().func_240699_a_(TextFormatting.ITALIC);
                TranslationTextComponent text = this.hasCustomSCName() ? ClientUtils.localize("messages.securitycraft:portableRadar.withName", attackedName, this.getCustomSCName().func_230531_f_().func_240699_a_(TextFormatting.ITALIC)) : ClientUtils.localize("messages.securitycraft:portableRadar.withoutName", attackedName, Utils.getFormattedCoordinates(this.field_174879_c));
                PlayerUtils.sendMessageToPlayer((PlayerEntity)owner, (IFormattableTextComponent)ClientUtils.localize(((Block)SCContent.PORTABLE_RADAR.get()).func_149739_a(), new Object[0]), (IFormattableTextComponent)text, TextFormatting.BLUE);
                this.setSentMessage();
            }
            if (this.hasModule(ModuleType.REDSTONE)) {
                PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attackFailed() {
        if (this.hasModule(ModuleType.REDSTONE)) {
            PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, ModuleType module) {
        super.onModuleRemoved(stack, module);
        if (module == ModuleType.REDSTONE) {
            PortableRadarBlock.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.func_74778_a("lastPlayerName", this.lastPlayerName);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        if (tag.func_74764_b("shouldSendNewMessage")) {
            this.shouldSendNewMessage = tag.func_74767_n("shouldSendNewMessage");
        }
        if (tag.func_74764_b("lastPlayerName")) {
            this.lastPlayerName = tag.func_74779_i("lastPlayerName");
        }
    }

    public boolean shouldSendMessage(PlayerEntity player) {
        if (!player.func_200200_C_().getString().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_200200_C_().getString();
        }
        return (this.shouldSendNewMessage || (Boolean)this.repeatMessageOption.get() != false) && (Boolean)this.enabledOption.get() != false && !player.func_200200_C_().getString().equals(this.getOwner().getName());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return (Double)this.searchRadiusOption.get();
    }

    @Override
    public int getTicksBetweenAttacks() {
        return (Integer)this.searchDelayOption.get() * 20;
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.REDSTONE, ModuleType.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }
}

