/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.block;

import com.github.sa_shiro.compressedblocks.block.BlockType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;

public class BlockFactory {
    private final BlockType type;
    private final String registryName;
    private final Material material;
    private final SoundType soundType;
    private int dustColor;
    private MaterialColor materialColor;
    private MaterialColor materialColorSide;
    private MaterialColor materialColorEnd;
    private String textureSide;
    private String textureEnd;
    private String textureParticle;
    private String textureDown;
    private String textureUp;
    private String textureNorth;
    private String textureSouth;
    private String textureEast;
    private String textureWest;
    private String namespace = null;
    private boolean hasCustomTexture = false;
    private boolean hasRotation = false;
    private boolean isLogBlock = false;

    @ParametersAreNonnullByDefault
    public BlockFactory(BlockType typeIn, String registryNameIn, Material materialIn, @Nullable MaterialColor materialColorIn, SoundType soundTypeIn) {
        if (materialColorIn == null) {
            materialColorIn = materialIn.func_151565_r();
        }
        this.type = typeIn;
        this.registryName = registryNameIn;
        this.dustColor = 0;
        this.material = materialIn;
        this.materialColor = materialColorIn;
        this.soundType = soundTypeIn;
    }

    @ParametersAreNonnullByDefault
    public BlockFactory(BlockType typeIn, String registryNameIn, int dustColorIn, Material materialIn, @Nullable MaterialColor materialColorIn, SoundType soundTypeIn) {
        if (materialColorIn == null) {
            materialColorIn = materialIn.func_151565_r();
        }
        this.type = typeIn;
        this.registryName = registryNameIn;
        this.dustColor = dustColorIn;
        this.material = materialIn;
        this.materialColor = materialColorIn;
        this.soundType = soundTypeIn;
    }

    @ParametersAreNonnullByDefault
    public BlockFactory(@Nonnull BlockType typeIn, String registryNameIn, Material materialIn, SoundType soundTypeIn) {
        this.type = typeIn;
        this.registryName = registryNameIn;
        this.material = materialIn;
        this.soundType = soundTypeIn;
    }

    public BlockType getType() {
        return this.type;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public int getDustColor() {
        return this.dustColor;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialColor getMaterialColor() {
        return this.materialColor;
    }

    public BlockFactory setMaterialColor(MaterialColor materialColorSide, MaterialColor materialColorEnd) {
        this.materialColorSide = materialColorSide;
        this.materialColorEnd = materialColorEnd;
        return this;
    }

    public MaterialColor getMaterialColorEnd() {
        return this.materialColorEnd;
    }

    public MaterialColor getMaterialColorSide() {
        return this.materialColorSide;
    }

    public SoundType getSoundType() {
        return this.soundType;
    }

    public boolean getHasCustomTexture() {
        return this.hasCustomTexture;
    }

    public String getTexturePath() {
        return this.namespace == null ? "minecraft" : this.namespace;
    }

    @ParametersAreNonnullByDefault
    public BlockFactory setCustomTexture(String particle, String side, String end) {
        this.hasCustomTexture = true;
        this.textureSide = side;
        this.textureEnd = end;
        return this.setCustomTexture(this.getTexturePath(), particle, end, end, side, side, side, side);
    }

    @ParametersAreNonnullByDefault
    public BlockFactory setCustomTexture(String particle, String down, String up, String north, String south, String east, String west) {
        return this.setCustomTexture(this.getTexturePath(), particle, down, up, north, south, east, west);
    }

    @ParametersAreNonnullByDefault
    public BlockFactory setCustomTexture(@Nullable String modID, String particle, String down, String up, String north, String south, String east, String west) {
        this.namespace = modID;
        this.hasCustomTexture = true;
        this.textureParticle = particle;
        this.textureDown = down;
        this.textureUp = up;
        this.textureNorth = north;
        this.textureSouth = south;
        this.textureEast = east;
        this.textureWest = west;
        return this;
    }

    public String getCustomTexture(TextureLocation location) {
        switch (location) {
            case DOWN: {
                return this.textureDown;
            }
            case NORTH: {
                return this.textureNorth;
            }
            case SOUTH: {
                return this.textureSouth;
            }
            case EAST: {
                return this.textureEast;
            }
            case WEST: {
                return this.textureWest;
            }
            case PARTICLE: {
                return this.textureParticle;
            }
            case SIDE: {
                return this.textureSide;
            }
            case END: {
                return this.textureEnd;
            }
        }
        return this.textureUp;
    }

    public boolean getHasRotation() {
        return this.hasRotation;
    }

    public BlockFactory hasRotation() {
        this.hasRotation = true;
        return this;
    }

    public BlockFactory isLogBlock() {
        this.isLogBlock = true;
        return this;
    }

    public boolean getIsLogBlock() {
        return this.isLogBlock;
    }

    public static enum TextureLocation {
        ALL,
        PARTICLE,
        UP,
        DOWN,
        NORTH,
        SOUTH,
        EAST,
        WEST,
        SIDE,
        END;

    }
}

