/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.block;

import com.github.sa_shiro.compressedblocks.block.BlockType;
import com.github.sa_shiro.compressedblocks.block.Compression;
import com.github.sa_shiro.compressedblocks.block.ICompressedBlock;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.GravelBlock;
import net.minecraft.block.MagmaBlock;
import net.minecraft.block.RedstoneBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SandBlock;
import net.minecraft.block.SlimeBlock;
import net.minecraft.block.SoulSandBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;

public class CompressedBlock
extends Block
implements ICompressedBlock {
    private final Compression compressor = new Compression();

    protected CompressedBlock(AbstractBlock.Properties p, int l) {
        super(p);
        this.compressor.setCompressionLevel(l);
    }

    @ParametersAreNonnullByDefault
    public static ICompressedBlock createBlock(BlockType type, int compression, Material material, @Nullable MaterialColor materialColor, SoundType soundType, float hardness, float resistance, int harvestLevel) {
        if (materialColor == null) {
            materialColor = material.func_151565_r();
        }
        AbstractBlock.Properties p0 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200948_a(hardness, resistance).harvestLevel(harvestLevel);
        AbstractBlock.Properties p1 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200943_b(5.0f).harvestLevel(0);
        AbstractBlock.Properties p2 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200943_b(0.5f).harvestLevel(0).func_226896_b_().func_200941_a(0.85f);
        AbstractBlock.Properties p3 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200943_b(5.0f).harvestLevel(0).func_200941_a(0.85f);
        AbstractBlock.Properties p4 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200943_b(0.3f).harvestLevel(0).func_226896_b_().func_226896_b_().func_235842_b_(CompressedBlock::nil).func_235847_c_(CompressedBlock::nil).func_235828_a_(CompressedBlock::nil).func_235827_a_(CompressedBlock::nil);
        AbstractBlock.Properties p5 = AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)materialColor).func_200947_a(soundType).func_200948_a(hardness, resistance).harvestLevel(harvestLevel).func_235838_a_(s -> 4);
        switch (type) {
            default: {
                return new CompressedBlock(p0, compression);
            }
            case SAND: {
                return new CompressedSandBlock(14406560, p0, compression);
            }
            case RED_SAND: {
                return new CompressedSandBlock(11098145, p0, compression);
            }
            case GRAVEL: {
                return new CompressedGravelBlock(p0, compression);
            }
            case REDSTONE: {
                return new CompressedRedstoneBlock(p0, compression);
            }
            case SOUL_SAND: {
                return new CompressedSoulSandBlock(p0, compression);
            }
            case WOOL: {
                return new CompressedBlock(p1, compression);
            }
            case SLIME: {
                return new CompressedSlimeBlock(p2, compression);
            }
            case FLESH: {
                return new CompressedBlock(p3, compression);
            }
            case GLASS: {
                return new CompressedTransparentBlock(p4, compression);
            }
            case MAGMA: 
        }
        return new CompressedMagmaBlock(p5, compression);
    }

    @ParametersAreNonnullByDefault
    public static ICompressedBlock createRotationalBlock(int compression, Material material, MaterialColor materialColorTop, MaterialColor materialColorEnd, SoundType soundType, float hardness, float resistance, int harvestLevel) {
        AbstractBlock.Properties p = AbstractBlock.Properties.func_235836_a_((Material)material, s -> s.func_177229_b((Property)RotatedPillarBlock.field_176298_M) == Direction.Axis.Y ? materialColorTop : materialColorEnd).func_200947_a(soundType).func_200948_a(hardness, resistance).harvestLevel(harvestLevel);
        return new CompressedRotationalBlock(p, compression);
    }

    @ParametersAreNonnullByDefault
    public static ICompressedBlock createRotationalBlock(int compression, Material material, MaterialColor materialColor, SoundType soundType, float hardness, float resistance, int harvestLevel) {
        AbstractBlock.Properties p = AbstractBlock.Properties.func_235836_a_((Material)material, state -> materialColor).func_200947_a(soundType).func_200948_a(hardness, resistance).harvestLevel(harvestLevel);
        return new CompressedRotationalBlock(p, compression);
    }

    private static boolean nil(BlockState s, IBlockReader r, BlockPos p) {
        return false;
    }

    private static boolean nil(BlockState s, IBlockReader r, BlockPos b, EntityType<?> e) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
        super.func_190948_a(s, w, t, i);
        t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    protected static class CompressedMagmaBlock
    extends MagmaBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedMagmaBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedTransparentBlock
    extends GlassBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedTransparentBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedRotationalBlock
    extends RotatedPillarBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedRotationalBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)field_176298_M, (Comparable)Direction.Axis.Y));
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedSoulSandBlock
    extends SoulSandBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedSoulSandBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedSlimeBlock
    extends SlimeBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedSlimeBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedSandBlock
    extends SandBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedSandBlock(int d, AbstractBlock.Properties p, int l) {
            super(d, p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedRedstoneBlock
    extends RedstoneBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedRedstoneBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }

    protected static class CompressedGravelBlock
    extends GravelBlock
    implements ICompressedBlock {
        private final Compression compressor = new Compression();

        protected CompressedGravelBlock(AbstractBlock.Properties p, int l) {
            super(p);
            this.compressor.setCompressionLevel(l);
        }

        @ParametersAreNonnullByDefault
        public void func_190948_a(ItemStack s, @Nullable IBlockReader w, List<ITextComponent> t, ITooltipFlag i) {
            super.func_190948_a(s, w, t, i);
            t.add((ITextComponent)new StringTextComponent(this.compressor.getBlockCount() + " Blocks").func_230530_a_(this.compressor.getStyle()));
        }

        @Override
        public Block getBlock() {
            return this;
        }
    }
}

