/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.event;

import com.github.sa_shiro.compressedblocks.block.BlockFactory;
import com.github.sa_shiro.compressedblocks.block.CompressedBlock;
import com.github.sa_shiro.compressedblocks.block.ICompressedBlock;
import com.github.sa_shiro.compressedblocks.event.ModRegistryObjects;
import com.github.sa_shiro.compressedblocks.item.BagItem;
import com.github.sa_shiro.compressedblocks.util.ItemGroups;
import com.github.sa_shiro.compressedblocks.util.JSONConfig;
import com.github.sa_shiro.compressedblocks.util.Lists;
import java.util.ArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModRegistryEvent {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
    private static final Item.Properties PROPERTIES = new Item.Properties().func_200916_a(ItemGroups.compressedBlockGroup);
    private static int INDEX = 0;

    public static void register() {
        ModRegistryObjects.BLOCKS.register(eventBus);
        ModRegistryObjects.BLOCKS2.register(eventBus);
        ModRegistryObjects.ITEMS.register(eventBus);
        ModRegistryObjects.BLOCKS2.register("logo_block", () -> ((Block)ModRegistryObjects.LOGO_BLOCK).getBlock());
        ModRegistryObjects.ITEMS.register("logo_block", () -> new BlockItem(ModRegistryObjects.LOGO_BLOCK, PROPERTIES));
        ModRegistryEvent.registerBlocks();
        ModRegistryEvent.registerItems();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(ModRegistryEvent::translucentRender));
    }

    private static void registerBlocks() {
        for (BlockFactory factory : Lists.blockList) {
            for (JSONConfig.BlockManager manager : JSONConfig.INSTANCE.blocks) {
                if (!factory.getRegistryName().equals(manager.getBlockName())) continue;
                for (int level = 0; level <= manager.getMaxCompressionLevel(); ++level) {
                    if (!factory.getHasRotation()) {
                        ModRegistryEvent.registerBlock(CompressedBlock.createBlock(factory.getType(), level, factory.getMaterial(), factory.getMaterialColor(), factory.getSoundType(), Lists.HARDNESS.get(level).floatValue(), Lists.RESISTANCE.get(level).floatValue(), Lists.HARVEST_LEVEL.get(level)), factory.getRegistryName(), level, manager.isEnabled());
                        continue;
                    }
                    if (factory.getIsLogBlock()) {
                        ModRegistryEvent.registerBlock(CompressedBlock.createRotationalBlock(level, factory.getMaterial(), factory.getMaterialColorSide(), factory.getMaterialColorEnd(), factory.getSoundType(), Lists.HARDNESS.get(level).floatValue(), Lists.RESISTANCE.get(level).floatValue(), Lists.HARVEST_LEVEL.get(level)), factory.getRegistryName(), level, manager.isEnabled());
                        continue;
                    }
                    if (!factory.getHasRotation() || factory.getIsLogBlock()) continue;
                    ModRegistryEvent.registerBlock(CompressedBlock.createRotationalBlock(level, factory.getMaterial(), factory.getMaterialColor(), factory.getSoundType(), Lists.HARDNESS.get(level).floatValue(), Lists.RESISTANCE.get(level).floatValue(), Lists.HARVEST_LEVEL.get(level)), factory.getRegistryName(), level, manager.isEnabled());
                }
            }
        }
        LOGGER.info("Registration finished.");
    }

    private static void translucentRender(FMLCommonSetupEvent e) {
        e.setPhase(EventPriority.NORMAL);
        RenderType TRANSLUCENT = RenderType.func_228645_f_();
        for (RegistryObject<Block> registryObject : ModRegistryObjects.BLOCK_REGISTRY) {
            RenderTypeLookup.setRenderLayer((Block)((Block)registryObject.get()), (RenderType)TRANSLUCENT);
        }
    }

    @ParametersAreNonnullByDefault
    private static void registerBlock(ICompressedBlock blockIn, String registryName, int compressionLevel, boolean isEnabled) {
        if (isEnabled) {
            int index2 = INDEX;
            ModRegistryObjects.BLOCK_REGISTRY.add(INDEX, (RegistryObject<Block>)ModRegistryObjects.BLOCKS.register("c" + compressionLevel + "_" + registryName, blockIn::getBlock));
            ModRegistryObjects.ITEMS.register("c" + compressionLevel + "_" + registryName, () -> new BlockItem((Block)ModRegistryObjects.BLOCK_REGISTRY.get(index2).get(), PROPERTIES));
            ++INDEX;
        }
    }

    private static void registerCrateItems(ArrayList<RegistryObject<Item>> array, String registryName) {
        array.add(1, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("crated_" + registryName, () -> new BagItem(0, ModRegistryEvent.stringFormat(registryName))));
        array.add(2, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("double_crated_" + registryName, () -> new BagItem(1, ModRegistryEvent.stringFormat(registryName))));
        array.add(3, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("triple_crated_" + registryName, () -> new BagItem(2, ModRegistryEvent.stringFormat(registryName))));
        array.add(4, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("quadruple_crated_" + registryName, () -> new BagItem(3, ModRegistryEvent.stringFormat(registryName))));
        array.add(5, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("quintuple_crated_" + registryName, () -> new BagItem(4, ModRegistryEvent.stringFormat(registryName))));
        array.add(6, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("sextuple_crated_" + registryName, () -> new BagItem(5, ModRegistryEvent.stringFormat(registryName))));
        array.add(7, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("septuple_crated_" + registryName, () -> new BagItem(6, ModRegistryEvent.stringFormat(registryName))));
        array.add(8, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("octuple_crated_" + registryName, () -> new BagItem(7, ModRegistryEvent.stringFormat(registryName))));
        array.add(9, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("mega_crated_" + registryName, () -> new BagItem(8, ModRegistryEvent.stringFormat(registryName))));
        array.add(10, (RegistryObject<Item>)ModRegistryObjects.ITEMS.register("giga_crated_" + registryName, () -> new BagItem(9, ModRegistryEvent.stringFormat(registryName))));
    }

    private static void registerItems() {
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.APPLES, "apples");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.ARROWS, "arrows");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.BEETROOT, "beetroots");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.BEETROOT_SEEDS, "beetroot_seeds");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.BLAZE_POWDER, "blaze_powder");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.BLAZE_RODS, "blaze_rods");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.BONES, "bones");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.CARROTS, "carrots");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.EGGS, "eggs");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.ENDER_EYES, "ender_eyes");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.ENDER_PEARLS, "ender_pearls");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.FEATHERS, "feathers");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.LEATHER, "leather");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.MELONS, "melons");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.POTATOES, "potatoes");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.SUGAR_CANE, "sugar_canes");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.MELON_SEEDS, "melon_seeds");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.PUMPKIN, "pumpkin");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.PUMPKIN_SEEDS, "pumpkin_seeds");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.WHEAT_SEEDS, "wheat_seeds");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.SPIDER_EYES, "spider_eyes");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.STRINGS, "strings");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.STICKS, "sticks");
        ModRegistryEvent.registerCrateItems(ModRegistryObjects.SUGAR, "sugar");
    }

    private static String stringFormat(String formatString) {
        formatString = formatString.replace("_", " ");
        String[] words = formatString.split("\\s");
        StringBuilder stringFormat = new StringBuilder();
        for (String str : words) {
            String first = str.substring(0, 1);
            String afterFirst = str.substring(1);
            stringFormat.append(first.toUpperCase()).append(afterFirst).append(" ");
        }
        return stringFormat.toString().trim();
    }
}

