/*
 * Decompiled with CFR 0.152.
 */
package com.github.sa_shiro.compressedblocks.util;

import com.github.sa_shiro.compressedblocks.block.BlockFactory;
import com.github.sa_shiro.compressedblocks.util.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class JSONConfig {
    public static JSONConfig INSTANCE = new JSONConfig();
    public List<BlockManager> blocks;

    public void init() {
        try {
            File file = new File(FMLPaths.CONFIGDIR.get().resolve("") + "/compressedblocks_list.json");
            if (!file.exists()) {
                BufferedWriter writer = Files.newBufferedWriter(Paths.get(String.valueOf(file), new String[0]), new OpenOption[0]);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                ArrayList<BlockManager> blocks = new ArrayList<BlockManager>();
                for (BlockFactory factory : Lists.blockList) {
                    blocks.add(new BlockManager(factory.getRegistryName(), true, 9));
                }
                gson.toJson(blocks, (Appendable)writer);
                ((Writer)writer).close();
            }
            BufferedReader reader = Files.newBufferedReader(Paths.get(String.valueOf(file), new String[0]));
            this.blocks = (List)new Gson().fromJson((Reader)reader, new TypeToken<List<BlockManager>>(){}.getType());
            ((Reader)reader).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class BlockManager {
        String blockName;
        boolean isEnabled;
        int maxCompressionLevel;

        public BlockManager(String blockName, boolean isEnabled, int maxCompressionLevel) {
            this.blockName = blockName;
            this.isEnabled = isEnabled;
            this.maxCompressionLevel = maxCompressionLevel;
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public String getBlockName() {
            return this.blockName;
        }

        public int getMaxCompressionLevel() {
            if (this.maxCompressionLevel > 9) {
                this.maxCompressionLevel = 9;
            }
            if (this.maxCompressionLevel < 0) {
                this.maxCompressionLevel = 0;
            }
            return this.maxCompressionLevel;
        }
    }
}

