/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.inventory;

import com.shinoow.abyssalcraft.api.APIUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;

public class InventoryCrystalBag
implements IInventory {
    private String name;
    public static int INV_SIZE;
    private NonNullList<ItemStack> inventory;
    private final ItemStack invItem;
    private final EnumHand hand;

    public InventoryCrystalBag(ItemStack stack, EnumHand hand) {
        this.invItem = stack;
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        INV_SIZE = stack.func_77978_p().func_74762_e("InvSize");
        this.inventory = NonNullList.func_191197_a((int)INV_SIZE, (Object)ItemStack.field_190927_a);
        this.name = stack.func_82833_r();
        this.hand = hand;
        this.readFromNBT(stack.func_77978_p());
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)amount);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int slot) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)slot);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inventory.set(slot, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return this.name;
    }

    public boolean func_145818_k_() {
        return this.name.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.func_70301_a(i).func_190926_b()) continue;
            this.inventory.set(i, (Object)ItemStack.field_190927_a);
        }
        this.writeToNBT(this.invItem.func_77978_p());
    }

    public boolean func_70300_a(EntityPlayer player) {
        return APIUtils.areStacksEqual(player.func_184586_b(this.hand), this.invItem);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return APIUtils.isCrystal(itemstack);
    }

    public void readFromNBT(NBTTagCompound tagcompound) {
        NBTTagList items = tagcompound.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            byte slot = item.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory.set((int)slot, (Object)new ItemStack(item));
        }
    }

    public void writeToNBT(NBTTagCompound tagcompound) {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            this.func_70301_a(i).func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tagcompound.func_74782_a("ItemInventory", (NBTBase)items);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }
}

