/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.items;

import com.shinoow.abyssalcraft.api.energy.IEnergyContainerItem;
import com.shinoow.abyssalcraft.api.energy.PEUtils;
import com.shinoow.abyssalcraft.client.ClientProxy;
import com.shinoow.abyssalcraft.client.handlers.AbyssalCraftClientEventHooks;
import com.shinoow.abyssalcraft.common.items.ItemACBasic;
import com.shinoow.abyssalcraft.common.network.PacketDispatcher;
import com.shinoow.abyssalcraft.common.network.server.InterdimensionalCageMessage;
import com.shinoow.abyssalcraft.lib.ACTabs;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemInterdimensionalCage
extends ItemACBasic
implements IEnergyContainerItem {
    public ItemInterdimensionalCage() {
        super("interdimensionalcage");
        this.func_77625_d(1);
        this.func_77637_a(ACTabs.tabTools);
        this.func_185043_a(new ResourceLocation("captured"), (stack, worldIn, entityIn) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("Entity") && stack.func_77978_p().func_74764_b("EntityName") ? 1.0f : 0.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs par2CreativeTab, NonNullList<ItemStack> par3List) {
        if (this.func_194125_a(par2CreativeTab)) {
            par3List.add((Object)new ItemStack((Item)this));
            ItemStack stack = new ItemStack((Item)this);
            this.addEnergy(stack, this.getMaxEnergy(stack));
            par3List.add((Object)stack);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77978_p().func_74764_b("Entity")) {
            if (world.field_72995_K) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            RayTraceResult movingobjectposition = this.func_77621_a(world, player, true);
            if (movingobjectposition == null) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = movingobjectposition.func_178782_a();
                if (!world.func_175660_a(player, blockpos)) {
                    return new ActionResult(EnumActionResult.PASS, (Object)stack);
                }
                if (!player.func_175151_a(blockpos, movingobjectposition.field_178784_b, stack)) {
                    return new ActionResult(EnumActionResult.PASS, (Object)stack);
                }
                Entity entity = this.spawnCreature(world, stack.func_77978_p().func_74775_l("Entity"), (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 1.5, (double)blockpos.func_177952_p() + 0.5);
                if (entity != null) {
                    stack.func_77978_p().func_82580_o("Entity");
                    stack.func_77978_p().func_82580_o("EntityName");
                }
            }
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        RayTraceResult mov = AbyssalCraftClientEventHooks.getMouseOverExtended(3.0f);
        if (mov != null && mov.field_72308_g != null && !mov.field_72308_g.field_70128_L && mov.field_72308_g != player) {
            PacketDispatcher.sendToServer(new InterdimensionalCageMessage(mov.field_72308_g.func_145782_y(), hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    private Entity spawnCreature(World worldIn, NBTTagCompound nbt, double x, double y, double z) {
        Entity entity = null;
        for (int i = 0; i < 1; ++i) {
            entity = EntityList.func_75615_a((NBTTagCompound)nbt, (World)worldIn);
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityLiving entityliving = (EntityLiving)entity;
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(worldIn.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entityliving.field_70759_as = entityliving.field_70177_z;
            entityliving.field_70761_aq = entityliving.field_70177_z;
            worldIn.func_72838_d(entity);
            entityliving.func_70642_aH();
        }
        return entity;
    }

    public void func_77624_a(ItemStack is, World player, List l, ITooltipFlag B) {
        if (is.func_77942_o() && is.func_77978_p().func_74764_b("EntityName")) {
            l.add("Captured Entity: " + is.func_77978_p().func_74779_i("EntityName"));
        }
        l.add("Press " + TextFormatting.GOLD + ClientProxy.use_cage.getDisplayName() + TextFormatting.GRAY + " to capture a mob");
    }

    public boolean func_77651_p() {
        return true;
    }

    @Override
    public float getContainedEnergy(ItemStack stack) {
        return PEUtils.getContainedEnergy(stack);
    }

    @Override
    public int getMaxEnergy(ItemStack stack) {
        return 1000;
    }

    @Override
    public void addEnergy(ItemStack stack, float energy) {
        PEUtils.addEnergy(this, stack, energy);
    }

    @Override
    public float consumeEnergy(ItemStack stack, float energy) {
        return PEUtils.consumeEnergy(stack, energy);
    }

    @Override
    public boolean canAcceptPE(ItemStack stack) {
        return this.getContainedEnergy(stack) < (float)this.getMaxEnergy(stack);
    }

    @Override
    public boolean canTransferPE(ItemStack stack) {
        return false;
    }
}

