/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.ritual;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.shinoow.abyssalcraft.api.biome.ACBiomes;
import com.shinoow.abyssalcraft.api.biome.IDreadlandsBiome;
import com.shinoow.abyssalcraft.api.entity.EntityUtil;
import com.shinoow.abyssalcraft.api.item.ACItems;
import com.shinoow.abyssalcraft.api.ritual.EnumRitualParticle;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import com.shinoow.abyssalcraft.common.util.BiomeUtil;
import com.shinoow.abyssalcraft.lib.ACConfig;
import com.shinoow.abyssalcraft.lib.ACLib;
import com.shinoow.abyssalcraft.lib.util.ScheduledProcess;
import com.shinoow.abyssalcraft.lib.util.Scheduler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class NecronomiconCuringRitual
extends NecronomiconRitual {
    private Biome replacementBiome;

    public NecronomiconCuringRitual() {
        super("curing", 4, 20000.0f, new ItemStack(ACItems.antidote, 1, 1), null, new ItemStack(ACItems.antidote, 1, 1), null, new ItemStack(ACItems.antidote, 1, 1), null, new ItemStack(ACItems.antidote, 1, 1));
        this.setRitualParticle(EnumRitualParticle.PE_STREAM);
    }

    @Override
    public boolean canCompleteRitual(World world, BlockPos pos, EntityPlayer player) {
        boolean ret = false;
        if (world.field_73011_w.getDimension() != ACLib.dreadlands_id) {
            for (int x = pos.func_177958_n() - 24; x < pos.func_177958_n() + 25; ++x) {
                for (int z = pos.func_177952_p() - 24; z < pos.func_177952_p() + 25; ++z) {
                    BlockPos pos1 = new BlockPos(x, 0, z);
                    if (!ret) {
                        if (!(world.func_180494_b(pos1) instanceof IDreadlandsBiome)) continue;
                        ret = true;
                        continue;
                    }
                    Biome biome = world.func_180494_b(pos1);
                    if (biome instanceof IDreadlandsBiome || biome == ACBiomes.purged) continue;
                    this.replacementBiome = biome;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected void completeRitualClient(World world, BlockPos pos, EntityPlayer player) {
    }

    @Override
    protected void completeRitualServer(final World world, BlockPos pos, EntityPlayer player) {
        int num = 1;
        int num2 = 0;
        int range = ACConfig.curingRitualRange * 8;
        for (int x = pos.func_177958_n() - range; x < pos.func_177958_n() + range + 1; ++x) {
            for (int z = pos.func_177952_p() - range; z < pos.func_177952_p() + range + 1; ++z) {
                final BlockPos pos1 = new BlockPos(x, 0, z);
                if (!(world.func_180494_b(pos1) instanceof IDreadlandsBiome)) continue;
                Scheduler.schedule(new ScheduledProcess(num * 2){

                    @Override
                    public void execute() {
                        for (EntityLivingBase e : world.func_175647_a(EntityLivingBase.class, new AxisAlignedBB(pos1).func_72314_b(3.0, 128.0, 3.0), Predicates.and((Predicate)EntitySelectors.field_94557_a, EntityUtil::isDreadPlagueCarrier))) {
                            e.func_174812_G();
                        }
                        BiomeUtil.updateBiome(world, pos1, NecronomiconCuringRitual.this.replacementBiome, true);
                    }
                });
                if (++num2 % 256 != 0) continue;
                ++num;
            }
        }
    }
}

