/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo;

import elucent.albedo.Albedo;
import elucent.albedo.ConfigManager;
import elucent.albedo.event.GatherLightsEvent;
import elucent.albedo.event.LightUniformEvent;
import elucent.albedo.event.ProfilerStartEvent;
import elucent.albedo.event.RenderChunkUniformsEvent;
import elucent.albedo.event.RenderEntityEvent;
import elucent.albedo.event.RenderTileEntityEvent;
import elucent.albedo.lighting.Light;
import elucent.albedo.lighting.LightManager;
import elucent.albedo.util.ShaderManager;
import elucent.albedo.util.ShaderUtil;
import elucent.albedo.util.TriConsumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class EventManager {
    public static final Map<BlockPos, List<Light>> EXISTING = Collections.synchronizedMap(new HashMap());
    public static boolean isGui = false;
    int ticks = 0;
    boolean postedLights = false;
    boolean precedesEntities = true;
    String section = "";
    Thread thread;

    public void startThread() {
        this.thread = new Thread(() -> {
            while (!this.thread.isInterrupted()) {
                if (Minecraft.func_71410_x().field_71439_g == null) continue;
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (Minecraft.func_71410_x().field_71441_e == null) continue;
                WorldClient reader = Minecraft.func_71410_x().field_71441_e;
                BlockPos playerPos = player.func_180425_c();
                int maxDistance = ConfigManager.maxDistance;
                int r = maxDistance / 2;
                Iterable posIterable = BlockPos.func_177975_b((BlockPos)playerPos.func_177982_a(-r, -r, -r), (BlockPos)playerPos.func_177982_a(r, r, r));
                for (BlockPos.MutableBlockPos pos : posIterable) {
                    Vec3d cameraPosition = LightManager.cameraPos;
                    ICamera camera = LightManager.camera;
                    IBlockState state = reader.func_180495_p((BlockPos)pos);
                    ArrayList<Light> lights = new ArrayList<Light>();
                    GatherLightsEvent lightsEvent = new GatherLightsEvent(lights, maxDistance, cameraPosition, camera);
                    TriConsumer<BlockPos, IBlockState, GatherLightsEvent> consumer = Albedo.getLightHandler(state.func_177230_c());
                    if (consumer != null) {
                        consumer.apply((BlockPos)pos, state, lightsEvent);
                    }
                    if (lights.isEmpty()) {
                        EXISTING.remove(pos);
                        continue;
                    }
                    EXISTING.put(pos.func_185334_h(), lights);
                }
            }
        });
        this.thread.start();
    }

    @SubscribeEvent
    public void onProfilerChange(ProfilerStartEvent event) {
        this.section = event.getSection();
        if (ConfigManager.isLightingEnabled()) {
            if (event.getSection().compareTo("terrain") == 0) {
                isGui = false;
                this.precedesEntities = true;
                ShaderUtil.fastLightProgram.useShader();
                ShaderUtil.fastLightProgram.setUniform("ticks", (float)this.ticks + Minecraft.func_71410_x().func_184121_ak());
                ShaderUtil.fastLightProgram.setUniform("sampler", 0);
                ShaderUtil.fastLightProgram.setUniform("lightmap", 1);
                ShaderUtil.fastLightProgram.setUniform("playerPos", (float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
                if (!this.postedLights) {
                    if (this.thread == null || !this.thread.isAlive()) {
                        this.startThread();
                    }
                    EXISTING.forEach((pos, lights) -> LightManager.lights.addAll((Collection<Light>)lights));
                    LightManager.update((World)Minecraft.func_71410_x().field_71441_e);
                    ShaderManager.stopShader();
                    MinecraftForge.EVENT_BUS.post((Event)new LightUniformEvent());
                    ShaderUtil.fastLightProgram.useShader();
                    LightManager.uploadLights();
                    ShaderUtil.entityLightProgram.useShader();
                    ShaderUtil.entityLightProgram.setUniform("ticks", (float)this.ticks + Minecraft.func_71410_x().func_184121_ak());
                    ShaderUtil.entityLightProgram.setUniform("sampler", 0);
                    ShaderUtil.entityLightProgram.setUniform("lightmap", 1);
                    LightManager.uploadLights();
                    ShaderUtil.entityLightProgram.setUniform("playerPos", (float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
                    ShaderUtil.entityLightProgram.setUniform("lightingEnabled", GL11.glIsEnabled((int)2896));
                    ShaderUtil.fastLightProgram.useShader();
                    this.postedLights = true;
                    LightManager.clear();
                }
            }
            if (event.getSection().compareTo("sky") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("litParticles") == 0) {
                ShaderUtil.fastLightProgram.useShader();
                ShaderUtil.fastLightProgram.setUniform("sampler", 0);
                ShaderUtil.fastLightProgram.setUniform("lightmap", 1);
                ShaderUtil.fastLightProgram.setUniform("playerPos", (float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
                ShaderUtil.fastLightProgram.setUniform("chunkX", 0);
                ShaderUtil.fastLightProgram.setUniform("chunkY", 0);
                ShaderUtil.fastLightProgram.setUniform("chunkZ", 0);
            }
            if (event.getSection().compareTo("particles") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("weather") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("entities") == 0 && Minecraft.func_71410_x().func_152345_ab()) {
                ShaderUtil.entityLightProgram.useShader();
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", true);
                ShaderUtil.entityLightProgram.setUniform("fogIntensity", Minecraft.func_71410_x().field_71441_e.field_73011_w.func_186058_p() == DimensionType.NETHER ? 0.015625f : 1.0f);
            }
            if (event.getSection().compareTo("blockEntities") == 0 && Minecraft.func_71410_x().func_152345_ab()) {
                ShaderUtil.entityLightProgram.useShader();
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", true);
            }
            if (event.getSection().compareTo("outline") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("aboveClouds") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("destroyProgress") == 0) {
                ShaderManager.stopShader();
            }
            if (event.getSection().compareTo("translucent") == 0) {
                ShaderUtil.fastLightProgram.useShader();
                ShaderUtil.fastLightProgram.setUniform("sampler", 0);
                ShaderUtil.fastLightProgram.setUniform("lightmap", 1);
                ShaderUtil.fastLightProgram.setUniform("playerPos", (float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
            }
            if (event.getSection().compareTo("hand") == 0) {
                ShaderUtil.entityLightProgram.useShader();
                ShaderUtil.fastLightProgram.setUniform("entityPos", (float)Minecraft.func_71410_x().field_71439_g.field_70165_t, (float)Minecraft.func_71410_x().field_71439_g.field_70163_u, (float)Minecraft.func_71410_x().field_71439_g.field_70161_v);
                this.precedesEntities = true;
            }
            if (event.getSection().compareTo("gui") == 0) {
                isGui = true;
                ShaderManager.stopShader();
            }
        }
    }

    @SubscribeEvent
    public void onRenderEntity(RenderEntityEvent event) {
        if (ConfigManager.isLightingEnabled()) {
            if (event.getEntity() instanceof EntityLightningBolt) {
                ShaderManager.stopShader();
            } else if (this.section.equalsIgnoreCase("entities") || this.section.equalsIgnoreCase("blockEntities")) {
                ShaderUtil.entityLightProgram.useShader();
            }
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("entityPos", (float)event.getEntity().field_70165_t, (float)event.getEntity().field_70163_u + event.getEntity().field_70131_O / 2.0f, (float)event.getEntity().field_70161_v);
            }
        }
    }

    @SubscribeEvent
    public void onRenderTileEntity(RenderTileEntityEvent event) {
        if (ConfigManager.isLightingEnabled()) {
            if (event.getEntity() instanceof TileEntityEndPortal || event.getEntity() instanceof TileEntityEndGateway) {
                ShaderManager.stopShader();
            } else if (this.section.equalsIgnoreCase("entities") || this.section.equalsIgnoreCase("blockEntities")) {
                ShaderUtil.entityLightProgram.useShader();
            }
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("entityPos", (float)event.getEntity().func_174877_v().func_177958_n(), (float)event.getEntity().func_174877_v().func_177956_o(), (float)event.getEntity().func_174877_v().func_177952_p());
            }
        }
    }

    @SubscribeEvent
    public void onRenderChunk(RenderChunkUniformsEvent event) {
        if (ConfigManager.isLightingEnabled() && ShaderManager.isCurrentShader(ShaderUtil.fastLightProgram)) {
            BlockPos pos = event.getChunk().func_178568_j();
            ShaderUtil.fastLightProgram.setUniform("chunkX", pos.func_177958_n());
            ShaderUtil.fastLightProgram.setUniform("chunkY", pos.func_177956_o());
            ShaderUtil.fastLightProgram.setUniform("chunkZ", pos.func_177952_p());
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.ticks;
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.postedLights = false;
        if (Minecraft.func_71410_x().func_152345_ab()) {
            GlStateManager.func_179140_f();
            ShaderManager.stopShader();
        }
    }
}

