/*
 * Decompiled with CFR 0.152.
 */
package elucent.albedo.util;

import elucent.albedo.util.ShaderUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL20;

public class ShaderManager {
    private static ShaderManager currentShader = null;
    private static int currentProgram = -1;
    private final int program;

    public ShaderManager(ResourceLocation shader, IResourceManager resourceManager) {
        this.program = ShaderUtil.loadProgram(String.format("%s:shaders/%s.vs", shader.func_110624_b(), shader.func_110623_a()), String.format("%s:shaders/%s.fs", shader.func_110624_b(), shader.func_110623_a()), resourceManager);
    }

    public static ShaderManager getCurrentShader() {
        return currentShader;
    }

    public static void stopShader() {
        if (currentProgram != 0) {
            GL20.glUseProgram((int)0);
            currentProgram = 0;
            currentShader = null;
        }
    }

    public static boolean isCurrentShader(ShaderManager shader) {
        return shader != null && currentProgram == shader.program;
    }

    public void useShader() {
        if (!ShaderManager.isCurrentShader(this)) {
            GL20.glUseProgram((int)this.program);
            currentProgram = this.program;
            currentShader = this;
        }
    }

    public void setUniform(String uniform, int value) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform1i((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (int)value);
        }
    }

    public void setUniform(String uniform, boolean value) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform1i((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (int)(value ? 1 : 0));
        }
    }

    public void setUniform(String uniform, float value) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform1f((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (float)value);
        }
    }

    public void setUniform(String uniform, int v1, int v2) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform2i((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (int)v1, (int)v2);
        }
    }

    public void setUniform(String uniform, int v1, int v2, int v3) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform3i((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (int)v1, (int)v2, (int)v3);
        }
    }

    public void setUniform(String uniform, float v1, float v2) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform2f((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (float)v1, (float)v2);
        }
    }

    public void setUniform(String uniform, float v1, float v2, float v3) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform3f((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (float)v1, (float)v2, (float)v3);
        }
    }

    public void setUniform(String uniform, float v1, float v2, float v3, float v4) {
        if (ShaderManager.isCurrentShader(this)) {
            GL20.glUniform4f((int)GL20.glGetUniformLocation((int)currentProgram, (CharSequence)uniform), (float)v1, (float)v2, (float)v3, (float)v4);
        }
    }
}

