/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.albedo.event;

import com.google.common.collect.ImmutableList;
import com.hrznstudio.albedo.lighting.Light;
import java.util.ArrayList;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.eventbus.api.Event;

public class GatherLightsEvent
extends Event {
    private final ArrayList<Light> lights;
    private final float maxDistance;
    private final Vec3d cameraPosition;
    private final ICamera camera;

    public GatherLightsEvent(ArrayList<Light> lights, float maxDistance, Vec3d cameraPosition, ICamera camera) {
        this.lights = lights;
        this.maxDistance = maxDistance;
        this.cameraPosition = cameraPosition;
        this.camera = camera;
    }

    public ImmutableList<Light> getLightList() {
        return ImmutableList.copyOf(this.lights);
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public Vec3d getCameraPosition() {
        return this.cameraPosition;
    }

    public ICamera getCamera() {
        return this.camera;
    }

    public void add(Light light) {
        double dist;
        float radius = light.radius();
        if (this.cameraPosition != null && (dist = (double)MathHelper.func_76133_a((double)this.cameraPosition.func_186679_c((double)light.x, (double)light.y, (double)light.z))) > (double)(radius + this.maxDistance)) {
            return;
        }
        if (this.camera != null && !this.camera.func_78546_a(new AxisAlignedBB((double)(light.x - radius), (double)(light.y - radius), (double)(light.z - radius), (double)(light.x + radius), (double)(light.y + radius), (double)(light.z + radius)))) {
            return;
        }
        this.lights.add(light);
    }

    public boolean isCancelable() {
        return false;
    }
}

