/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.albedo.lighting;

import com.hrznstudio.albedo.Albedo;
import com.hrznstudio.albedo.ConfigManager;
import com.hrznstudio.albedo.event.GatherLightsEvent;
import com.hrznstudio.albedo.lighting.Light;
import com.hrznstudio.albedo.util.ShaderManager;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;

public class LightManager {
    public static Vec3d cameraPos;
    public static ICamera camera;
    public static ArrayList<Light> lights;
    public static DistComparator distComparator;

    public static void uploadLights() {
        ShaderManager shader = ShaderManager.getCurrentShader();
        shader.setUniform("lightCount", lights.size());
        for (int i = 0; i < Math.min((Integer)ConfigManager.maxLights.get(), lights.size()); ++i) {
            if (i >= lights.size()) continue;
            Light l = lights.get(i);
            shader.setUniform("lights[" + i + "].position", l.x, l.y, l.z);
            shader.setUniform("lights[" + i + "].color", l.r, l.g, l.b, l.a);
            shader.setUniform("lights[" + i + "].heading", l.rx, l.ry, l.rz);
            shader.setUniform("lights[" + i + "].angle", l.angle);
        }
    }

    private static Vec3d interpolate(Entity entity, float partialTicks) {
        return new Vec3d(entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks, entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks, entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks);
    }

    public static void update(World world) {
        LazyOptional provider;
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        if (cameraEntity == null) {
            if (cameraPos == null) {
                cameraPos = new Vec3d(0.0, 0.0, 0.0);
            }
            camera = null;
            return;
        }
        cameraPos = LightManager.interpolate(cameraEntity, mc.func_184121_ak());
        camera = new Frustum();
        camera.func_78547_a(LightManager.cameraPos.field_72450_a, LightManager.cameraPos.field_72448_b, LightManager.cameraPos.field_72449_c);
        GatherLightsEvent event = new GatherLightsEvent(lights, ((Integer)ConfigManager.maxDistance.get()).intValue(), cameraPos, camera);
        MinecraftForge.EVENT_BUS.post((Event)event);
        int maxDist = (Integer)ConfigManager.maxDistance.get();
        for (Entity e : world.func_72872_a(Entity.class, new AxisAlignedBB(LightManager.cameraPos.field_72450_a - (double)maxDist, LightManager.cameraPos.field_72448_b - (double)maxDist, LightManager.cameraPos.field_72449_c - (double)maxDist, LightManager.cameraPos.field_72450_a + (double)maxDist, LightManager.cameraPos.field_72448_b + (double)maxDist, LightManager.cameraPos.field_72449_c + (double)maxDist))) {
            if (e instanceof EntityItem) {
                provider = ((EntityItem)e).func_92059_d().getCapability(Albedo.LIGHT_PROVIDER_CAPABILITY);
                provider.ifPresent(p -> p.gatherLights(event, e));
            }
            provider = e.getCapability(Albedo.LIGHT_PROVIDER_CAPABILITY);
            provider.ifPresent(p -> p.gatherLights(event, e));
            for (ItemStack itemStack : e.func_184214_aD()) {
                provider = itemStack.getCapability(Albedo.LIGHT_PROVIDER_CAPABILITY);
                provider.ifPresent(p -> p.gatherLights(event, e));
            }
            for (ItemStack itemStack : e.func_184193_aE()) {
                provider = itemStack.getCapability(Albedo.LIGHT_PROVIDER_CAPABILITY);
                provider.ifPresent(p -> p.gatherLights(event, e));
            }
        }
        for (TileEntity t : world.field_147482_g) {
            provider = t.getCapability(Albedo.LIGHT_PROVIDER_CAPABILITY);
            provider.ifPresent(p -> p.gatherLights(event, null));
        }
        lights.sort(distComparator);
    }

    public static void clear() {
        lights.clear();
    }

    static {
        lights = new ArrayList();
        distComparator = new DistComparator();
    }

    public static class DistComparator
    implements Comparator<Light> {
        @Override
        public int compare(Light a, Light b) {
            double dist1 = cameraPos.func_186679_c((double)a.x, (double)a.y, (double)a.z);
            double dist2 = cameraPos.func_186679_c((double)b.x, (double)b.y, (double)b.z);
            return Double.compare(dist1, dist2);
        }
    }
}

