/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.albedo.util;

import com.hrznstudio.albedo.ConfigManager;
import com.hrznstudio.albedo.EventManager;
import com.hrznstudio.albedo.event.RenderChunkUniformsEvent;
import com.hrznstudio.albedo.util.ShaderManager;
import com.hrznstudio.albedo.util.ShaderUtil;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class RenderUtil {
    public static boolean lightingEnabled = false;
    public static ShaderManager previousShader;
    public static boolean enabledLast;
    public static ItemCameraTransforms.TransformType itemTransformType;

    public static void renderChunkUniforms(RenderChunk c) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderChunkUniformsEvent(c));
    }

    public static void enableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.isLightingEnabled()) {
            if (enabledLast) {
                if (previousShader != null) {
                    previousShader.useShader();
                }
                enabledLast = false;
            }
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", true);
            }
        }
    }

    public static void disableLightingUniforms() {
        if (!EventManager.isGui && ConfigManager.isLightingEnabled()) {
            if (ShaderManager.isCurrentShader(ShaderUtil.entityLightProgram)) {
                ShaderUtil.entityLightProgram.setUniform("lightingEnabled", false);
            }
            if (!enabledLast) {
                previousShader = ShaderManager.getCurrentShader();
                enabledLast = true;
                ShaderManager.stopShader();
            }
        }
    }

    public static void setTransform(ItemCameraTransforms.TransformType t) {
        itemTransformType = t;
    }

    static {
        enabledLast = false;
        itemTransformType = ItemCameraTransforms.TransformType.NONE;
    }
}

