/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.albedo.util;

import com.hrznstudio.albedo.util.ShaderManager;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.resource.VanillaResourceType;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

public class ShaderUtil
implements ISelectiveResourceReloadListener {
    public static ShaderManager fastLightProgram;
    public static ShaderManager entityLightProgram;
    public static ShaderManager depthProgram;

    public static void init(IResourceManager manager) {
        fastLightProgram = new ShaderManager(new ResourceLocation("albedo:fastlight"), manager);
        entityLightProgram = new ShaderManager(new ResourceLocation("albedo:entitylight"), manager);
        depthProgram = new ShaderManager(new ResourceLocation("albedo:depth"), manager);
    }

    public static int loadProgram(String vsh, String fsh, IResourceManager manager) {
        int vertexShader = ShaderUtil.createShader(vsh, OpenGlHelper.field_153209_q, manager);
        int fragmentShader = ShaderUtil.createShader(fsh, OpenGlHelper.field_153210_r, manager);
        int program = OpenGlHelper.func_153183_d();
        OpenGlHelper.func_153178_b((int)program, (int)vertexShader);
        OpenGlHelper.func_153178_b((int)program, (int)fragmentShader);
        OpenGlHelper.func_153179_f((int)program);
        String s = GL20.glGetProgramInfoLog((int)program);
        System.out.println("GL LOG: " + s);
        return program;
    }

    public static int createShader(String filename, int shaderType, IResourceManager manager) {
        int shader = OpenGlHelper.func_153195_b((int)shaderType);
        if (shader == 0) {
            return 0;
        }
        try {
            String s = ShaderUtil.readFileAsString(filename, manager);
            OpenGlHelper.func_195918_a((int)shader, (CharSequence)s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        OpenGlHelper.func_153170_c((int)shader);
        if (GL20.glGetShaderi((int)shader, (int)OpenGlHelper.field_153208_p) == 0) {
            throw new RuntimeException("Error creating shader: " + ShaderUtil.getLogInfo(shader));
        }
        return shader;
    }

    public static String getLogInfo(int obj) {
        return ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
    }

    public static String readFileAsString(String filename, IResourceManager manager) throws Exception {
        System.out.println("Loading shader [" + filename + "]...");
        InputStream in = null;
        try {
            IResource resource = manager.func_199002_a(new ResourceLocation(filename));
            in = resource.func_199027_b();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        String s = "";
        if (in != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
                s = reader.lines().collect(Collectors.joining("\n"));
            }
        }
        return s;
    }

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SHADERS)) {
            ShaderUtil.init(resourceManager);
        }
    }
}

