/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.gui;

import com.google.common.collect.ImmutableSet;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.AllomancyConfig;
import com.legobmw99.allomancy.util.AllomancyUtils;
import com.legobmw99.allomancy.util.Registry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GUIMetalSelect
extends GuiScreen {
    private static final String[] METAL_NAMES = new String[]{"Iron", "Steel", "Tin", "Pewter", "Zinc", "Brass", "Copper", "Bronze"};
    private static final String GUI_METAL = "allomancy:textures/gui/metals/sign%d.png";
    private static final ResourceLocation[] METAL_ICONS = new ResourceLocation[]{new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 0)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 1)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 2)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 3)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 4)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 5)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 6)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 7))};
    int timeIn = AllomancyConfig.animateSelection ? 0 : 10;
    int slotSelected = -1;
    AllomancyCapability cap;
    List<Integer> slots;

    public GUIMetalSelect() {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        this.cap = AllomancyCapability.forPlayer((Entity)player);
        this.slots = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            this.slots.add(i);
        }
    }

    public void func_73863_a(int mx, int my, float partialTicks) {
        super.func_73863_a(mx, my, partialTicks);
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        int x = this.field_146294_l / 2;
        int y = this.field_146295_m / 2;
        int maxRadius = 80;
        boolean mouseIn = true;
        float angle = GUIMetalSelect.mouseAngle(x, y, mx, my);
        GlStateManager.func_179147_l();
        GlStateManager.func_179103_j((int)7425);
        int segments = this.slots.size();
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)segments;
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        this.slotSelected = -1;
        for (int seg = 0; seg < segments; ++seg) {
            boolean mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            GL11.glBegin((int)6);
            float gs = 0.3f;
            if (seg % 2 == 1) {
                gs += 0.25f;
            }
            gs = this.cap.getMetalAmounts((seg + 4) % 8) == 0 ? 0.0f : gs;
            float r = this.cap.getMetalBurning((seg + 4) % 8) ? 1.0f : gs;
            float g = gs;
            float b = gs;
            float a = 0.6f;
            if (mouseInSector) {
                this.slotSelected = seg;
            }
            GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
            GL11.glVertex2i((int)x, (int)y);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if (i == (float)((int)(degPer / 2.0f))) {
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, mouseInSector ? 110 : 114});
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, this.cap.getMetalAmounts((seg + 4) % 8) == 0 ? 55 : 102});
                }
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179098_w();
        for (int[] pos : stringPositions) {
            int slot = this.slots.get(pos[0]);
            int xp = pos[1];
            int yp = pos[2];
            char c = (char)pos[3];
            int xsp = xp - 4;
            int ysp = yp;
            String name = "\u00a7" + c + METAL_NAMES[(slot + 4) % 8];
            int width = this.field_146289_q.func_78256_a(name);
            double mod = 0.6;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.field_146289_q.func_175063_a(name, (float)xsp, (float)ysp, 0xFFFFFF);
            mod = 0.8;
            xdp = (int)((double)(xp - x) * mod + (double)x);
            ydp = (int)((double)(yp - y) * mod + (double)y);
            this.field_146297_k.field_71446_o.func_110577_a(METAL_ICONS[(slot + 4) % 8]);
            GUIMetalSelect.func_146110_a((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
        }
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        float s = 3.0f * fract;
        GlStateManager.func_179091_B();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        RenderHelper.func_74518_a();
        GlStateManager.func_179084_k();
        GlStateManager.func_179101_C();
        GlStateManager.func_179121_F();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.toggleSelected();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!GameSettings.func_100015_a((KeyBinding)Registry.burn)) {
            this.field_146297_k.func_147108_a(null);
        }
        ImmutableSet set = ImmutableSet.of((Object)this.field_146297_k.field_71474_y.field_74351_w, (Object)this.field_146297_k.field_71474_y.field_74370_x, (Object)this.field_146297_k.field_71474_y.field_74368_y, (Object)this.field_146297_k.field_71474_y.field_74366_z, (Object)this.field_146297_k.field_71474_y.field_74311_E, (Object)this.field_146297_k.field_71474_y.field_151444_V, (Object[])new KeyBinding[]{this.field_146297_k.field_71474_y.field_74314_A});
        for (KeyBinding k : set) {
            KeyBinding.func_74510_a((int)k.func_151463_i(), (boolean)GameSettings.func_100015_a((KeyBinding)k));
        }
        ++this.timeIn;
    }

    private void toggleSelected() {
        if (this.slotSelected != -1) {
            int slot = this.slots.get(this.slotSelected);
            slot = (slot + 4) % 8;
            AllomancyUtils.toggleMetalBurn(slot, this.cap);
            Minecraft.func_71410_x().field_71439_g.func_184185_a(new SoundEvent(new ResourceLocation("ui.button.click")), 0.1f, 2.0f);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(Vector2f.dot((Vector2f)baseVec, (Vector2f)mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

