/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.handlers;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.network.packets.AllomancyPowerPacket;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.AllomancyConfig;
import com.legobmw99.allomancy.util.AllomancyUtils;
import com.legobmw99.allomancy.util.Registry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class CommonEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer && !((Entity)event.getObject()).hasCapability(Allomancy.PLAYER_CAP, null)) {
            event.addCapability(new ResourceLocation("allomancy", "Allomancy_Data"), (ICapabilityProvider)new AllomancyCapability());
        }
    }

    @SubscribeEvent
    public void onDamage(LivingHurtEvent event) {
        AllomancyCapability cap;
        EntityPlayerMP source;
        AllomancyCapability cap2;
        if (event.getSource().func_76346_g() instanceof EntityPlayerMP && (cap2 = AllomancyCapability.forPlayer((Entity)(source = (EntityPlayerMP)event.getSource().func_76346_g()))).getMetalBurning(3)) {
            event.setAmount(event.getAmount() + 2.0f);
        }
        if (event.getEntityLiving() instanceof EntityPlayerMP && (cap = AllomancyCapability.forPlayer((Entity)event.getEntityLiving())).getMetalBurning(3)) {
            event.setAmount(event.getAmount() - 2.0f);
            cap.setDamageStored(cap.getDamageStored() + 1);
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        String name = event.getName().toString();
        if (name.startsWith("minecraft:chests/simple_dungeon") || name.startsWith("minecraft:chests/desert_pyramid") || name.startsWith("minecraft:chests/jungle_temple")) {
            event.getTable().addPool(new LootPool(new LootEntry[]{new LootEntryTable(new ResourceLocation("allomancy", "inject/lerasium"), 1, 0, new LootCondition[0], "allomancy_inject_entry")}, new LootCondition[0], new RandomValueRange(1.0f), new RandomValueRange(0.0f, 1.0f), "allomancy_inject_pool"));
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        AllomancyCapability oldCap = AllomancyCapability.forPlayer((Entity)event.getOriginal());
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)event.getEntityPlayer());
        if (oldCap.getAllomancyPower() >= 0) {
            cap.setAllomancyPower(oldCap.getAllomancyPower());
            Registry.network.sendTo((IMessage)new AllomancyPowerPacket(oldCap.getAllomancyPower()), (EntityPlayerMP)event.getEntity());
        }
        if (event.getEntityPlayer().field_70170_p.func_82736_K().func_82766_b("keepInventory") || !event.isWasDeath()) {
            for (int i = 0; i < 8; ++i) {
                cap.setMetalAmounts(i, oldCap.getMetalAmounts(i));
                Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap, event.getEntity().func_145782_y()), (EntityPlayerMP)event.getEntity());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.getEntity();
            AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
            Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap, event.getEntity().func_145782_y()), player);
            if (cap.getAllomancyPower() >= 0) {
                Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap, player.func_145782_y()), player);
            } else if (AllomancyConfig.randomizeMistings && cap.getAllomancyPower() == -1) {
                int randomMisting = (int)(Math.random() * 8.0);
                cap.setAllomancyPower(randomMisting);
                Registry.network.sendTo((IMessage)new AllomancyPowerPacket(randomMisting), player);
                ItemStack dust = new ItemStack(Item.func_111206_d((String)("allomancy:flake" + Registry.flakeMetals[randomMisting])));
                if (!player.field_71071_by.func_70441_a(dust)) {
                    EntityItem entity = new EntityItem(event.getEntity().func_130014_f_(), player.field_70165_t, player.field_70163_u, player.field_70161_v, dust);
                    event.getEntity().func_130014_f_().func_72838_d((Entity)entity);
                }
            }
        }
    }

    @SubscribeEvent
    public void onRegisterItems(RegistryEvent.Register<Item> event) {
        Registry.initItems(event);
    }

    @SubscribeEvent
    public void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        Registry.initBlocks(event);
    }

    @SubscribeEvent
    public void onRegisterRecipes(RegistryEvent.Register<IRecipe> event) {
        Registry.setupRecipes(event);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            World world = event.world;
            List list = world.field_73010_i;
            for (EntityPlayer curPlayer : list) {
                AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)curPlayer);
                if (cap.getAllomancyPower() < 0) continue;
                if (curPlayer instanceof EntityPlayerMP) {
                    AllomancyUtils.updateMetalBurnTime(cap, (EntityPlayerMP)curPlayer);
                }
                if (!cap.getMetalBurning(3) && cap.getDamageStored() > 0) {
                    cap.setDamageStored(cap.getDamageStored() - 1);
                    curPlayer.func_70097_a(DamageSource.field_76376_m, 2.0f);
                }
                if (cap.getMetalBurning(3)) {
                    curPlayer.func_70690_d(new PotionEffect(Potion.func_188412_a((int)8), 30, 1, true, false));
                    curPlayer.func_70690_d(new PotionEffect(Potion.func_188412_a((int)1), 30, 0, true, false));
                    if (cap.getDamageStored() > 0 && world.field_73012_v.nextInt(200) == 0) {
                        cap.setDamageStored(cap.getDamageStored() - 1);
                    }
                }
                if (cap.getMetalBurning(2)) {
                    curPlayer.func_70690_d(new PotionEffect(Potion.func_188412_a((int)16), Short.MAX_VALUE, 5, true, false));
                    if (curPlayer.func_70644_a(Potion.func_188412_a((int)15))) {
                        curPlayer.func_184589_d(Potion.func_188412_a((int)15));
                    } else {
                        PotionEffect potionEffect = curPlayer.func_70660_b(Potion.func_188412_a((int)16));
                    }
                }
                if (cap.getMetalBurning(2) || curPlayer.func_70660_b(Potion.func_188412_a((int)16)) == null || curPlayer.func_70660_b(Potion.func_188412_a((int)16)).func_76458_c() != 5) continue;
                curPlayer.func_184589_d(Potion.func_188412_a((int)16));
            }
        }
    }
}

