/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.network.packets;

import com.legobmw99.allomancy.ai.AIAttackOnCollideExtended;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ChangeEmotionPacket
implements IMessage {
    private int entityID;
    private int aggro;

    public ChangeEmotionPacket() {
    }

    public ChangeEmotionPacket(int entityID, boolean aggro) {
        this.entityID = entityID;
        this.aggro = aggro ? 1 : 0;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5);
        this.aggro = ByteBufUtils.readVarInt((ByteBuf)buf, (int)1);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.entityID, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buf, (int)this.aggro, (int)1);
    }

    static class AIEvilAttack
    extends EntityAIAttackMelee {
        public AIEvilAttack(EntityRabbit rabbit) {
            super((EntityCreature)rabbit, 1.4, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    public static class Handler
    implements IMessageHandler<ChangeEmotionPacket, IMessage> {
        public IMessage onMessage(final ChangeEmotionPacket message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityCreature target = (EntityCreature)ctx.getServerHandler().field_147369_b.field_70170_p.func_73045_a(message.entityID);
                    if (target != null && message.aggro == 1) {
                        target.field_70714_bg.field_75782_a.clear();
                        target.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)target));
                        target.field_70714_bg.func_75776_a(5, (EntityAIBase)new AIAttackOnCollideExtended(target, 1.0, false));
                        target.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget(target, EntityPlayer.class, false));
                        target.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander(target, 0.8));
                        target.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)target, EntityPlayer.class, 8.0f));
                        target.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)target));
                        target.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget(target, false, new Class[0]));
                        if (target instanceof EntityCreeper) {
                            target.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)target));
                        }
                        if (target instanceof EntityRabbit) {
                            target.field_70714_bg.func_75776_a(4, (EntityAIBase)new AIEvilAttack((EntityRabbit)target));
                        }
                        return;
                    }
                    if (target != null && message.aggro == 0) {
                        target.field_70714_bg.field_75782_a.clear();
                        target.func_70624_b((EntityLivingBase)target);
                        target.func_70604_c((EntityLivingBase)target);
                        target.func_70604_c((EntityLivingBase)target);
                        target.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)target));
                        target.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic(target, 0.5));
                        target.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander(target, 1.0));
                        target.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)target, EntityPlayer.class, 6.0f));
                        target.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)target));
                        return;
                    }
                }
            });
            return null;
        }
    }
}

