/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import com.legobmw99.allomancy.Allomancy;
import java.util.concurrent.Callable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class AllomancyCapability
implements ICapabilitySerializable<NBTTagCompound> {
    public static final ResourceLocation IDENTIFIER = new ResourceLocation("allomancy", "Allomancy_Data");
    public static final int[] MAX_BURN_TIME = new int[]{1800, 1800, 3600, 600, 1800, 1800, 2400, 1600};
    public static final int IRON = 0;
    public static final int STEEL = 1;
    public static final int TIN = 2;
    public static final int PEWTER = 3;
    public static final int ZINC = 4;
    public static final int BRASS = 5;
    public static final int COPPER = 6;
    public static final int BRONZE = 7;
    private int allomancyPower = -1;
    private int damageStored = 0;
    private int[] BurnTime = new int[]{1800, 1800, 3600, 1500, 1800, 1800, 2400, 2400};
    private int[] MetalAmounts = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    private boolean[] MetalBurning = new boolean[]{false, false, false, false, false, false, false, false};

    public static AllomancyCapability forPlayer(Entity player) {
        return (AllomancyCapability)player.getCapability(Allomancy.PLAYER_CAP, null);
    }

    public int getAllomancyPower() {
        return this.allomancyPower;
    }

    public void setAllomancyPower(int pow) {
        this.allomancyPower = pow;
    }

    public boolean getMetalBurning(int metal) {
        return this.MetalBurning[metal];
    }

    public void setMetalBurning(int metal, boolean metalBurning) {
        this.MetalBurning[metal] = metalBurning;
    }

    public int getDamageStored() {
        return this.damageStored;
    }

    public void setDamageStored(int damageStored) {
        this.damageStored = damageStored;
    }

    public int getMetalAmounts(int metal) {
        return metal >= 0 && metal < 8 ? this.MetalAmounts[metal] : 0;
    }

    public void setMetalAmounts(int metal, int metalAmounts) {
        this.MetalAmounts[metal] = metalAmounts;
    }

    public int getBurnTime(int metal) {
        return this.BurnTime[metal];
    }

    public void setBurnTime(int metal, int burnTime) {
        this.BurnTime[metal] = burnTime;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(AllomancyCapability.class, (Capability.IStorage)new Storage(), (Callable)new Factory());
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("allomancyPower", this.getAllomancyPower());
        nbt.func_74768_a("iron", this.getMetalAmounts(0));
        nbt.func_74768_a("steel", this.getMetalAmounts(1));
        nbt.func_74768_a("tin", this.getMetalAmounts(2));
        nbt.func_74768_a("pewter", this.getMetalAmounts(3));
        nbt.func_74768_a("zinc", this.getMetalAmounts(4));
        nbt.func_74768_a("brass", this.getMetalAmounts(5));
        nbt.func_74768_a("copper", this.getMetalAmounts(6));
        nbt.func_74768_a("bronze", this.getMetalAmounts(7));
        nbt.func_74757_a("iron_b", this.getMetalBurning(0));
        nbt.func_74757_a("steel_b", this.getMetalBurning(1));
        nbt.func_74757_a("tin_b", this.getMetalBurning(2));
        nbt.func_74757_a("pewter_b", this.getMetalBurning(3));
        nbt.func_74757_a("zinc_b", this.getMetalBurning(4));
        nbt.func_74757_a("brass_b", this.getMetalBurning(5));
        nbt.func_74757_a("copper_b", this.getMetalBurning(6));
        nbt.func_74757_a("bronze_b", this.getMetalBurning(7));
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound compound) {
        this.allomancyPower = compound.func_74762_e("allomancyPower");
        this.MetalAmounts[0] = compound.func_74762_e("iron");
        this.MetalAmounts[1] = compound.func_74762_e("steel");
        this.MetalAmounts[2] = compound.func_74762_e("tin");
        this.MetalAmounts[3] = compound.func_74762_e("pewter");
        this.MetalAmounts[4] = compound.func_74762_e("zinc");
        this.MetalAmounts[5] = compound.func_74762_e("brass");
        this.MetalAmounts[6] = compound.func_74762_e("copper");
        this.MetalAmounts[7] = compound.func_74762_e("bronze");
        this.MetalBurning[0] = compound.func_74767_n("iron_b");
        this.MetalBurning[1] = compound.func_74767_n("steel_b");
        this.MetalBurning[2] = compound.func_74767_n("tin_b");
        this.MetalBurning[3] = compound.func_74767_n("pewter_b");
        this.MetalBurning[4] = compound.func_74767_n("zinc_b");
        this.MetalBurning[5] = compound.func_74767_n("brass_b");
        this.MetalBurning[6] = compound.func_74767_n("copper_b");
        this.MetalBurning[7] = compound.func_74767_n("bronze_b");
        if (compound.func_74767_n("ismistborn")) {
            this.setAllomancyPower(8);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return Allomancy.PLAYER_CAP != null && capability == Allomancy.PLAYER_CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(Allomancy.PLAYER_CAP != null && capability == Allomancy.PLAYER_CAP ? this : null);
    }

    public static class Factory
    implements Callable<AllomancyCapability> {
        @Override
        public AllomancyCapability call() throws Exception {
            return null;
        }
    }

    public static class Storage
    implements Capability.IStorage<AllomancyCapability> {
        public NBTBase writeNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<AllomancyCapability> capability, AllomancyCapability instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

