/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.util;

import com.legobmw99.allomancy.Allomancy;
import com.legobmw99.allomancy.entities.EntityGoldNugget;
import com.legobmw99.allomancy.entities.EntityIronNugget;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.network.packets.UpdateBurnPacket;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.Registry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.opengl.GL11;

public class AllomancyUtils {
    private static final ArrayList<String> metallist = new ArrayList();
    private static File whitelist;
    public static final int PUSH = 1;
    public static final int PULL = -1;

    public static void init() {
        AllomancyUtils.generateWhitelist();
        AllomancyUtils.populateMetalList();
    }

    private static void generateWhitelist() {
        BufferedWriter output = null;
        whitelist = new File(Allomancy.configDirectory, "allomancy-whitelist.txt");
        if (!whitelist.exists()) {
            ArrayList<String> defaultList = new ArrayList<String>();
            defaultList.add(Items.field_151036_c.getRegistryName().toString());
            defaultList.add(Items.field_151006_E.getRegistryName().toString());
            defaultList.add(Items.field_151029_X.getRegistryName().toString());
            defaultList.add(Items.field_151151_aj.getRegistryName().toString());
            defaultList.add(Items.field_151167_ab.getRegistryName().toString());
            defaultList.add(Items.field_151133_ar.getRegistryName().toString());
            defaultList.add(Items.field_151129_at.getRegistryName().toString());
            defaultList.add(Items.field_151117_aB.getRegistryName().toString());
            defaultList.add(Items.field_151131_as.getRegistryName().toString());
            defaultList.add(Items.field_151066_bu.getRegistryName().toString());
            defaultList.add(Items.field_151111_aL.getRegistryName().toString());
            defaultList.add(Items.field_151033_d.getRegistryName().toString());
            defaultList.add(Items.field_151074_bl.getRegistryName().toString());
            defaultList.add(Items.field_191525_da.getRegistryName().toString());
            defaultList.add(Items.field_151020_U.getRegistryName().toString());
            defaultList.add(Items.field_151169_ag.getRegistryName().toString());
            defaultList.add(Items.field_151028_Y.getRegistryName().toString());
            defaultList.add(Items.field_151013_M.getRegistryName().toString());
            defaultList.add(Items.field_151019_K.getRegistryName().toString());
            defaultList.add(Items.field_151136_bY.getRegistryName().toString());
            defaultList.add(Items.field_151138_bX.getRegistryName().toString());
            defaultList.add(Items.field_151022_W.getRegistryName().toString());
            defaultList.add(Items.field_151149_ai.getRegistryName().toString());
            defaultList.add(Items.field_151165_aa.getRegistryName().toString());
            defaultList.add(Items.field_151143_au.getRegistryName().toString());
            defaultList.add(Items.field_151108_aI.getRegistryName().toString());
            defaultList.add(Items.field_151140_bW.getRegistryName().toString());
            defaultList.add(Items.field_151109_aJ.getRegistryName().toString());
            defaultList.add(Items.field_151142_bV.getRegistryName().toString());
            defaultList.add(Items.field_151035_b.getRegistryName().toString());
            defaultList.add(Items.field_151005_D.getRegistryName().toString());
            defaultList.add(Items.field_151030_Z.getRegistryName().toString());
            defaultList.add(Items.field_151023_V.getRegistryName().toString());
            defaultList.add(Items.field_151171_ah.getRegistryName().toString());
            defaultList.add(Items.field_151113_aN.getRegistryName().toString());
            defaultList.add(Items.field_151011_C.getRegistryName().toString());
            defaultList.add(Items.field_151037_a.getRegistryName().toString());
            defaultList.add(Items.field_151097_aZ.getRegistryName().toString());
            defaultList.add(Items.field_151153_ao.getRegistryName().toString());
            defaultList.add(Items.field_151153_ao.getRegistryName().toString());
            defaultList.add(Items.field_151150_bK.getRegistryName().toString());
            defaultList.add(Items.field_151040_l.getRegistryName().toString());
            defaultList.add(Registry.nuggetLerasium.getRegistryName().toString());
            defaultList.add(Registry.itemAllomancyGrinder.getRegistryName().toString());
            defaultList.add(Registry.itemCoinBag.getRegistryName().toString());
            defaultList.add(Blocks.field_150467_bQ.getRegistryName().toString());
            defaultList.add(Blocks.field_180400_cw.getRegistryName().toString());
            defaultList.add(Blocks.field_150454_av.getRegistryName().toString());
            defaultList.add(Blocks.field_150383_bp.getRegistryName().toString());
            defaultList.add(Blocks.field_150411_aY.getRegistryName().toString());
            defaultList.add(Blocks.field_150438_bZ.getRegistryName().toString());
            defaultList.add(Blocks.field_150332_K.getRegistryName().toString());
            defaultList.add(Blocks.field_180384_M.getRegistryName().toString());
            defaultList.add(Blocks.field_150320_F.getRegistryName().toString());
            defaultList.add(Blocks.field_150331_J.getRegistryName().toString());
            defaultList.add(Blocks.field_150445_bS.getRegistryName().toString());
            defaultList.add(Blocks.field_150443_bT.getRegistryName().toString());
            defaultList.add(Blocks.field_150448_aq.getRegistryName().toString());
            defaultList.add(Blocks.field_150408_cc.getRegistryName().toString());
            defaultList.add(Blocks.field_150319_E.getRegistryName().toString());
            defaultList.add(Blocks.field_150318_D.getRegistryName().toString());
            defaultList.add(Registry.itemVial.getRegistryName().toString());
            defaultList.add(Registry.blockIronLever.getRegistryName().toString());
            for (int i = 0; i < Registry.flakeMetals.length; ++i) {
                new Item();
                defaultList.add(Item.func_111206_d((String)("allomancy:flake" + Registry.flakeMetals[i])).getRegistryName().toString());
            }
            String[] ores = OreDictionary.getOreNames();
            for (String s : ores) {
                if (!s.contains("Copper") && !s.contains("Tin") && !s.contains("Gold") && !s.contains("Iron") && !s.contains("Steel") && !s.contains("Lead") && !s.contains("Silver") && !s.contains("Brass") && !s.contains("Bronze") && !s.contains("Aluminum") && !s.contains("Zinc")) continue;
                for (ItemStack i : OreDictionary.getOres((String)s)) {
                    String name;
                    if (i.func_77973_b() == null || defaultList.contains(name = i.func_77973_b().getRegistryName().toString())) continue;
                    defaultList.add(name);
                }
            }
            Collections.sort(defaultList);
            try {
                whitelist.createNewFile();
                output = new BufferedWriter(new FileWriter(whitelist));
                output.write("# Add the registry names of blocks or items to the list below for them to be treated as metals \n");
                for (String item : defaultList) {
                    output.write(item + "\n");
                }
                output.close();
                defaultList.clear();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private static void populateMetalList() {
        try {
            if (!whitelist.exists()) {
                return;
            }
            Scanner scanner = new Scanner(whitelist);
            while (scanner.hasNext()) {
                String[] line = scanner.next().split("\\n");
                String[] tokens = line[0].split("#");
                if (tokens.length != 1) continue;
                metallist.add(line[0]);
            }
            scanner.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawMetalLine(double pX, double pY, double pZ, double oX, double oY, double oZ, float width, float r, float g, float b) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslated((double)(-pX), (double)(-pY), (double)(-pZ));
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)width);
        GL11.glColor3f((float)r, (float)g, (float)b);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)pX, (double)(pY + 1.2), (double)pZ);
        GL11.glVertex3d((double)oX, (double)oY, (double)oZ);
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public static RayTraceResult getMouseOverExtended(float dist) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, AllomancyUtils.addCoord(theViewBoundingBox, lookvec.field_72450_a * (double)dist, lookvec.field_72448_b * (double)dist, lookvec.field_72449_c * (double)dist).func_72321_a((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72321_a((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new RayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    public static AxisAlignedBB addCoord(AxisAlignedBB a, double x, double y, double z) {
        double d0 = a.field_72340_a;
        double d1 = a.field_72338_b;
        double d2 = a.field_72339_c;
        double d3 = a.field_72336_d;
        double d4 = a.field_72337_e;
        double d5 = a.field_72334_f;
        if (x < 0.0) {
            d0 += x;
        } else if (x > 0.0) {
            d3 += x;
        }
        if (y < 0.0) {
            d1 += y;
        } else if (y > 0.0) {
            d4 += y;
        }
        if (z < 0.0) {
            d2 += z;
        } else if (z > 0.0) {
            d5 += z;
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public static boolean isBlockMetal(Block block) {
        return metallist.contains(block.getRegistryName().toString());
    }

    public static boolean isItemMetal(ItemStack item) {
        return item != null && metallist.contains(item.func_77973_b().getRegistryName().toString());
    }

    public static boolean isEntityMetal(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityItem) {
            return AllomancyUtils.isItemMetal(((EntityItem)entity).func_92059_d());
        }
        if (entity instanceof EntityItemFrame) {
            return AllomancyUtils.isItemMetal(((EntityItemFrame)entity).func_82335_i());
        }
        if (entity instanceof EntityIronNugget || entity instanceof EntityGoldNugget) {
            return true;
        }
        if (entity instanceof EntityMinecart) {
            return true;
        }
        if (entity instanceof EntityLiving) {
            EntityLiving ent = (EntityLiving)entity;
            if (ent instanceof EntityIronGolem) {
                return true;
            }
            if (AllomancyUtils.isItemMetal(ent.func_184586_b(EnumHand.MAIN_HAND)) || AllomancyUtils.isItemMetal(ent.func_184586_b(EnumHand.OFF_HAND))) {
                return true;
            }
            for (ItemStack i : ent.func_184193_aE()) {
                if (!AllomancyUtils.isItemMetal(i)) continue;
                return true;
            }
        }
        return false;
    }

    public static void move(double directionScalar, Entity toMove, BlockPos vec) {
        if (toMove.func_184218_aH()) {
            toMove = toMove.func_184187_bx();
        }
        double magnitude = Math.sqrt(Math.pow(toMove.field_70165_t - ((double)vec.func_177958_n() + 0.5), 2.0) + Math.pow(toMove.field_70163_u - ((double)vec.func_177956_o() + 0.5), 2.0) + Math.pow(toMove.field_70161_v - ((double)vec.func_177952_p() + 0.5), 2.0));
        double motionX = (toMove.field_70165_t - ((double)vec.func_177958_n() + 0.5)) * directionScalar * 1.1 / magnitude;
        double motionY = (toMove.field_70163_u - ((double)vec.func_177956_o() + 0.5)) * directionScalar * 1.1 / magnitude;
        double motionZ = (toMove.field_70161_v - ((double)vec.func_177952_p() + 0.5)) * directionScalar * 1.1 / magnitude;
        toMove.field_70159_w = Math.abs(toMove.field_70159_w + motionX) > 0.01 ? MathHelper.func_151237_a((double)(toMove.field_70159_w + motionX), (double)(-Math.abs(motionX)), (double)motionX) : 0.0;
        toMove.field_70181_x = Math.abs(toMove.field_70181_x + motionY) > 0.01 ? MathHelper.func_151237_a((double)(toMove.field_70181_x + motionY), (double)(-Math.abs(motionY)), (double)motionY) : 0.0;
        toMove.field_70179_y = Math.abs(toMove.field_70179_y + motionZ) > 0.01 ? MathHelper.func_151237_a((double)(toMove.field_70179_y + motionZ), (double)(-Math.abs(motionZ)), (double)motionZ) : 0.0;
        toMove.field_70133_I = true;
        if (toMove instanceof EntityPlayerMP) {
            toMove.field_70143_R = 0.0f;
        }
    }

    public static void toggleMetalBurn(int metal, AllomancyCapability capability) {
        Registry.network.sendToServer((IMessage)new UpdateBurnPacket(metal, !capability.getMetalBurning(metal)));
        if (capability.getMetalAmounts(metal) > 0) {
            capability.setMetalBurning(metal, !capability.getMetalBurning(metal));
        }
        if (capability.getMetalBurning(metal)) {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(new SoundEvent(new ResourceLocation("item.flintandsteel.use")), 1.0f, 5.0f);
        } else {
            Minecraft.func_71410_x().field_71439_g.func_184185_a(new SoundEvent(new ResourceLocation("block.fire.extinguish")), 1.0f, 4.0f);
        }
    }

    public static void updateMetalBurnTime(AllomancyCapability cap1, EntityPlayerMP player) {
        for (int i = 0; i < 8; ++i) {
            if (!cap1.getMetalBurning(i)) continue;
            if (cap1.getAllomancyPower() != i && cap1.getAllomancyPower() != 8) {
                cap1.setMetalBurning(i, false);
                Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap1, player.func_145782_y()), player);
                continue;
            }
            cap1.setBurnTime(i, cap1.getBurnTime(i) - 1);
            if (cap1.getBurnTime(i) != 0) continue;
            cap1.setBurnTime(i, AllomancyCapability.MAX_BURN_TIME[i]);
            cap1.setMetalAmounts(i, cap1.getMetalAmounts(i) - 1);
            Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap1, player.func_145782_y()), player);
            if (cap1.getMetalAmounts(i) != 0) continue;
            cap1.setMetalBurning(i, false);
            Registry.network.sendTo((IMessage)new AllomancyCapabilityPacket(cap1, player.func_145782_y()), player);
        }
    }
}

