/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.world;

import com.legobmw99.allomancy.util.AllomancyConfig;
import com.legobmw99.allomancy.util.Registry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.fml.common.IWorldGenerator;

public class OreGenerator
implements IWorldGenerator {
    private ArrayList<OreData> oreList = new ArrayList();

    public OreGenerator() {
        OreData data = new OreData(AllomancyConfig.copperMaxY, AllomancyConfig.copperMinY, 8, 4, AllomancyConfig.copperDensity, Registry.oreCopper, AllomancyConfig.generateCopper);
        this.oreList.add(data);
        data = new OreData(AllomancyConfig.tinMaxY, AllomancyConfig.tinMinY, 8, 4, AllomancyConfig.tinDensity, Registry.oreTin, AllomancyConfig.generateTin);
        this.oreList.add(data);
        data = new OreData(AllomancyConfig.leadMaxY, AllomancyConfig.leadMinY, 8, 4, AllomancyConfig.leadDensity, Registry.oreLead, AllomancyConfig.generateLead);
        this.oreList.add(data);
        data = new OreData(AllomancyConfig.zincMaxY, AllomancyConfig.zincMinY, 8, 4, AllomancyConfig.zincDensity, Registry.oreZinc, AllomancyConfig.generateZinc);
        this.oreList.add(data);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.getDimension() != 0) {
            return;
        }
        for (OreData data : this.oreList) {
            int numCluster = random.nextInt(5);
            if (numCluster == 0 && data.clusterPerChunk != 0) {
                numCluster = 1;
            }
            if (!data.config) continue;
            for (int count = 0; count < numCluster; ++count) {
                int x = random.nextInt(16);
                int z = random.nextInt(16);
                int y = random.nextInt(data.maxHeight);
                int numOre = MathHelper.func_76125_a((int)random.nextInt(data.maxCluster), (int)data.minCluster, (int)data.maxCluster);
                BlockPos pos = new BlockPos(x += 16 * chunkX, y += data.minHeight, z += 16 * chunkZ);
                new WorldGenMinable(data.oreType.func_176223_P(), numOre * 2).func_180709_b(world, random, pos);
            }
        }
    }

    public class OreData {
        public int maxHeight;
        public int minHeight;
        public int maxCluster;
        public int minCluster;
        public int clusterPerChunk;
        public Block oreType;
        public Block curblock;
        public boolean config;

        public OreData(int MaxHeight, int MinHeight, int MaxCluster, int MinCluster, int PerChunk, Block OreType, boolean Config) {
            this.maxHeight = MaxHeight;
            this.minHeight = MinHeight;
            this.maxCluster = MaxCluster;
            this.minCluster = MinCluster;
            this.clusterPerChunk = PerChunk;
            this.oreType = OreType;
            this.config = Config;
        }
    }
}

