/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy;

import com.legobmw99.allomancy.client.ClientEventHandler;
import com.legobmw99.allomancy.client.ClientSetup;
import com.legobmw99.allomancy.command.AllomancyPowerCommand;
import com.legobmw99.allomancy.command.AllomancyPowerType;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.setup.Registry;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.CommonEventHandler;
import com.legobmw99.allomancy.world.OreGenerator;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ArgumentSerializer;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="allomancy")
public class Allomancy {
    public static final String MODID = "allomancy";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Allomancy instance;

    public Allomancy() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::modConfig);
        MinecraftForge.EVENT_BUS.addListener(this::serverInit);
        Registry.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, AllomancyConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, AllomancyConfig.CLIENT_SPEC);
    }

    public void clientInit(FMLClientSetupEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ClientSetup.initKeyBindings();
        ClientSetup.registerEntityRenders();
    }

    public void serverInit(FMLServerStartingEvent e) {
        AllomancyPowerCommand.register((CommandDispatcher<CommandSource>)e.getCommandDispatcher());
    }

    public void init(FMLCommonSetupEvent e) {
        ArgumentTypes.func_218136_a((String)"allomancy_power", AllomancyPowerType.class, (IArgumentSerializer)new ArgumentSerializer(AllomancyPowerType::powerType));
        OreGenerator.generationSetup();
        AllomancyCapability.register();
        MinecraftForge.EVENT_BUS.register((Object)new CommonEventHandler());
        Network.registerPackets();
    }

    public void modConfig(ModConfig.ModConfigEvent e) {
        ModConfig cfg = e.getConfig();
        if (cfg.getSpec() == AllomancyConfig.CLIENT_SPEC) {
            AllomancyConfig.refreshClient();
        } else if (cfg.getSpec() == AllomancyConfig.COMMON_SPEC) {
            AllomancyConfig.refreshCommon();
        }
    }
}

