/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.client;

import com.legobmw99.allomancy.client.ClientSetup;
import com.legobmw99.allomancy.client.ClientUtils;
import com.legobmw99.allomancy.client.entity.particle.SoundParticle;
import com.legobmw99.allomancy.client.gui.MetalSelectScreen;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.ChangeEmotionPacket;
import com.legobmw99.allomancy.network.packets.TryPushPullBlock;
import com.legobmw99.allomancy.network.packets.TryPushPullEntity;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.setup.Registry;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.legobmw99.allomancy.util.AllomancyUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEventHandler {
    private final Minecraft mc = Minecraft.func_71410_x();
    private Set<Entity> metal_entities = new HashSet<Entity>();
    private Set<BlockPos> metal_blocks = new HashSet<BlockPos>();
    private Set<PlayerEntity> nearby_allomancers = new HashSet<PlayerEntity>();

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player;
        AllomancyCapability cap;
        if (event.phase == TickEvent.Phase.END && !this.mc.func_147113_T() && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70089_S() && (cap = AllomancyCapability.forPlayer((Entity)(player = this.mc.field_71439_g))).getAllomancyPower() >= 0) {
            Entity entity2;
            BlockPos bp;
            RayTraceResult trace;
            if (this.mc.field_71474_y.field_74312_F.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f);
                if (cap.getMetalBurning(0) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && AllomancyUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), -1));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (AllomancyUtils.isBlockMetal(this.mc.field_71441_e.func_180495_p(bp = ((BlockRayTraceResult)trace).func_216350_a()).func_177230_c()) || player.func_184614_ca().func_77973_b() == Registry.COIN_BAG.get() && player.func_70093_af())) {
                        Network.sendToServer(new TryPushPullBlock(bp, -1));
                    }
                }
                if (cap.getMetalBurning(4) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), true));
                }
            }
            if (this.mc.field_71474_y.field_74313_G.func_151470_d()) {
                trace = ClientUtils.getMouseOverExtended(20.0f);
                if (cap.getMetalBurning(1) && trace != null) {
                    if (trace.func_216346_c() == RayTraceResult.Type.ENTITY && AllomancyUtils.isEntityMetal(((EntityRayTraceResult)trace).func_216348_a())) {
                        Network.sendToServer(new TryPushPullEntity(((EntityRayTraceResult)trace).func_216348_a().func_145782_y(), 1));
                    }
                    if (trace.func_216346_c() == RayTraceResult.Type.BLOCK && (AllomancyUtils.isBlockMetal(this.mc.field_71441_e.func_180495_p(bp = ((BlockRayTraceResult)trace).func_216350_a()).func_177230_c()) || player.func_184614_ca().func_77973_b() == Registry.COIN_BAG.get() && player.func_70093_af())) {
                        Network.sendToServer(new TryPushPullBlock(bp, 1));
                    }
                }
                if (cap.getMetalBurning(5) && trace != null && trace.func_216346_c() == RayTraceResult.Type.ENTITY && (entity2 = ((EntityRayTraceResult)trace).func_216348_a()) instanceof CreatureEntity) {
                    Network.sendToServer(new ChangeEmotionPacket(entity2.func_145782_y(), false));
                }
            }
            this.metal_blocks.clear();
            this.metal_entities.clear();
            if (cap.getMetalBurning(0) || cap.getMetalBurning(1)) {
                int xLoc = (int)player.field_70165_t;
                int yLoc = (int)player.field_70163_u;
                int zLoc = (int)player.field_70161_v;
                int max = AllomancyConfig.max_metal_detection;
                BlockPos negative = new BlockPos(xLoc - max, yLoc - max, zLoc - max);
                BlockPos positive = new BlockPos(xLoc + max, yLoc + max, zLoc + max);
                List entities = player.field_70170_p.func_217357_a(Entity.class, new AxisAlignedBB(negative, positive));
                entities.forEach(entity -> {
                    if (AllomancyUtils.isEntityMetal(entity)) {
                        this.metal_entities.add((Entity)entity);
                    }
                });
                Stream blocks = BlockPos.func_218281_b((BlockPos)negative, (BlockPos)positive);
                blocks.forEach(arg_0 -> this.lambda$onClientTick$1((PlayerEntity)player, arg_0));
            }
            this.nearby_allomancers.clear();
            if (cap.getMetalBurning(7) && !cap.getMetalBurning(6)) {
                int xLoc = (int)player.field_70165_t;
                int yLoc = (int)player.field_70163_u;
                int zLoc = (int)player.field_70161_v;
                BlockPos negative = new BlockPos(xLoc - 30, yLoc - 30, zLoc - 30);
                BlockPos positive = new BlockPos(xLoc + 30, yLoc + 30, zLoc + 30);
                List nearby_players = player.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB(negative, positive), arg_0 -> ClientEventHandler.lambda$onClientTick$2((PlayerEntity)player, arg_0));
                for (PlayerEntity otherPlayer : nearby_players) {
                    AllomancyCapability capOther = AllomancyCapability.forPlayer((Entity)otherPlayer);
                    if (capOther.getMetalBurning(6)) {
                        this.nearby_allomancers.clear();
                        return;
                    }
                    if (!capOther.getMetalBurning(0) && !capOther.getMetalBurning(1) && !capOther.getMetalBurning(2) && !capOther.getMetalBurning(3) && !capOther.getMetalBurning(4) && !capOther.getMetalBurning(5) && !capOther.getMetalBurning(7)) continue;
                    this.nearby_allomancers.add(otherPlayer);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ClientSetup.burn.func_151468_f()) {
            ClientPlayerEntity player = this.mc.field_71439_g;
            if (this.mc.field_71462_r == null) {
                if (player == null || !this.mc.func_195544_aj()) {
                    return;
                }
                AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
                if (cap.getAllomancyPower() >= 0 && cap.getAllomancyPower() < 8) {
                    ClientUtils.toggleMetalBurn(cap.getAllomancyPower(), cap);
                }
                if (cap.getAllomancyPower() == 8) {
                    this.mc.func_147108_a((Screen)new MetalSelectScreen());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        if (!this.mc.func_195544_aj() || !this.mc.field_71439_g.func_70089_S()) {
            return;
        }
        if (this.mc.field_71462_r != null && !(this.mc.field_71462_r instanceof ChatScreen) && !(this.mc.field_71462_r instanceof MetalSelectScreen)) {
            return;
        }
        ClientUtils.drawMetalOverlay();
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderGUIScreen(GuiScreenEvent.DrawScreenEvent event) {
        if (event.getGui() instanceof MetalSelectScreen && !event.isCancelable()) {
            ClientUtils.drawMetalOverlay();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null || !player.func_70089_S()) {
            return;
        }
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        if (cap.getAllomancyPower() < 0) {
            return;
        }
        double playerX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)event.getPartialTicks();
        double playerY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)event.getPartialTicks();
        double playerZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)event.getPartialTicks();
        if (cap.getMetalBurning(0) || cap.getMetalBurning(1)) {
            for (Entity entity : this.metal_entities) {
                ClientUtils.drawMetalLine(playerX, playerY, playerZ, entity.field_70165_t, entity.field_70163_u - 1.25 + (double)entity.func_213302_cg() / 2.0, entity.field_70161_v, 1.5f, 0.0f, 0.6f, 1.0f);
            }
            for (BlockPos v : this.metal_blocks) {
                ClientUtils.drawMetalLine(playerX, playerY, playerZ, (double)v.func_177958_n() + 0.5, (double)v.func_177956_o() - 1.0, (double)v.func_177952_p() + 0.5, 1.5f, 0.0f, 0.6f, 1.0f);
            }
        }
        if (cap.getMetalBurning(7) && !cap.getMetalBurning(6)) {
            for (PlayerEntity playerEntity : this.nearby_allomancers) {
                ClientUtils.drawMetalLine(playerX, playerY, playerZ, playerEntity.field_70165_t, playerEntity.field_70163_u - 0.5, playerEntity.field_70161_v, 3.0f, 0.7f, 0.15f, 0.15f);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onSound(PlaySoundEvent event) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        ISound sound = event.getSound();
        if (player == null || sound == null || !player.func_70089_S()) {
            return;
        }
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        if (cap.getMetalBurning(2)) {
            double magnitude = Math.sqrt(Math.pow(player.field_70165_t - (double)sound.func_147649_g(), 2.0) + Math.pow(player.field_70163_u - (double)sound.func_147654_h(), 2.0) + Math.pow(player.field_70161_v - (double)sound.func_147651_i(), 2.0));
            if (magnitude > 25.0 || magnitude < 3.0) {
                return;
            }
            String soundName = sound.func_147650_b().toString();
            if (soundName.contains("entity") || soundName.contains("step")) {
                double motionX = (player.field_70165_t - ((double)event.getSound().func_147649_g() + 0.5)) * -0.7 / magnitude;
                double motionY = (player.field_70163_u - ((double)event.getSound().func_147654_h() + 0.2)) * -0.7 / magnitude;
                double motionZ = (player.field_70161_v - ((double)event.getSound().func_147651_i() + 0.5)) * -0.7 / magnitude;
                SoundParticle particle = new SoundParticle(player.field_70170_p, player.field_70165_t + Math.sin(Math.toRadians(player.func_70079_am())) * -0.7, player.field_70163_u + 0.2, player.field_70161_v + Math.cos(Math.toRadians(player.func_70079_am())) * 0.7, motionX, motionY, motionZ, sound.func_184365_d());
                this.mc.field_71452_i.func_78873_a((Particle)particle);
            }
        }
    }

    private static /* synthetic */ boolean lambda$onClientTick$2(PlayerEntity player, PlayerEntity entity) {
        return entity != null && entity != player;
    }

    private /* synthetic */ void lambda$onClientTick$1(PlayerEntity player, BlockPos bp) {
        BlockPos imBlock = bp.func_185334_h();
        if (AllomancyUtils.isBlockMetal(player.field_70170_p.func_180495_p(imBlock).func_177230_c())) {
            this.metal_blocks.add(imBlock);
        }
    }
}

