/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.client;

import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.UpdateBurnPacket;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.util.AllomancyCapability;
import java.awt.Point;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class ClientUtils {
    private static final Point[] Frames = new Point[]{new Point(72, 0), new Point(72, 4), new Point(72, 8), new Point(72, 12)};
    private static final ResourceLocation meterLoc = new ResourceLocation("allomancy", "textures/gui/overlay/meter.png");
    private static int animationCounter = 0;
    private static int currentFrame = 0;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static ClientPlayerEntity player = ClientUtils.mc.field_71439_g;
    private static AllomancyCapability cap;

    @Nullable
    public static RayTraceResult getMouseOverExtended(float dist) {
        mc = Minecraft.func_71410_x();
        float partialTicks = mc.func_184121_ak();
        RayTraceResult objectMouseOver = null;
        Entity entity = mc.func_175606_aa();
        if (entity != null && ClientUtils.mc.field_71441_e != null) {
            objectMouseOver = entity.func_213324_a((double)dist, partialTicks, false);
            Vec3d vec3d = entity.func_174824_e(partialTicks);
            boolean flag = false;
            int i = 3;
            double d1 = dist * dist;
            if (objectMouseOver != null) {
                d1 = objectMouseOver.func_216347_e().func_72436_e(vec3d);
            }
            Vec3d vec3d1 = entity.func_70676_i(1.0f);
            Vec3d vec3d2 = vec3d.func_72441_c(vec3d1.field_72450_a * (double)dist, vec3d1.field_72448_b * (double)dist, vec3d1.field_72449_c * (double)dist);
            float f = 1.0f;
            AxisAlignedBB axisalignedbb = entity.func_174813_aQ().func_216361_a(vec3d1.func_186678_a((double)dist)).func_72314_b(1.0, 1.0, 1.0);
            EntityRayTraceResult entityraytraceresult = ProjectileHelper.func_221273_a((Entity)entity, (Vec3d)vec3d, (Vec3d)vec3d2, (AxisAlignedBB)axisalignedbb, e -> true, (double)d1);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.func_216348_a();
                Vec3d vec3d3 = entityraytraceresult.func_216347_e();
                double d2 = vec3d.func_72436_e(vec3d3);
                if (d2 < d1) {
                    objectMouseOver = entityraytraceresult;
                }
            }
        }
        return objectMouseOver;
    }

    public static void drawMetalLine(double pX, double pY, double pZ, double oX, double oY, double oZ, float width, float r, float g, float b) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslated((double)(-pX), (double)(-pY), (double)(-pZ));
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3553);
        GL11.glLineWidth((float)width);
        GL11.glColor3f((float)r, (float)g, (float)b);
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)pX, (double)(pY - 0.5), (double)pZ);
        GL11.glVertex3d((double)oX, (double)oY, (double)oZ);
        GL11.glEnd();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    public static void drawMetalOverlay() {
        int renderX;
        player = ClientUtils.mc.field_71439_g;
        if (!player.func_70089_S()) {
            return;
        }
        cap = AllomancyCapability.forPlayer((Entity)player);
        if (cap.getAllomancyPower() < 0) {
            return;
        }
        ++animationCounter;
        int renderY = 0;
        MainWindow res = Minecraft.func_71410_x().field_195558_d;
        switch (AllomancyConfig.overlay_position) {
            case TOP_LEFT: {
                renderX = res.func_198107_o() - 95;
                renderY = 10;
                break;
            }
            case BOTTOM_RIGHT: {
                renderX = res.func_198107_o() - 95;
                renderY = res.func_198087_p() - 40;
                break;
            }
            case BOTTOM_LEFT: {
                renderX = 5;
                renderY = res.func_198087_p() - 40;
                break;
            }
            default: {
                renderX = 5;
                renderY = 10;
            }
        }
        IngameGui gig = new IngameGui(mc);
        ClientUtils.mc.func_175598_ae().field_78724_e.func_110577_a(meterLoc);
        ITextureObject obj = ClientUtils.mc.func_175598_ae().field_78724_e.func_110581_b(meterLoc);
        GL11.glBindTexture((int)3553, (int)obj.func_110552_b());
        if (cap.getAllomancyPower() >= 0 && cap.getAllomancyPower() < 8) {
            int singleMetalY = 9 - cap.getMetalAmounts(cap.getAllomancyPower());
            gig.blit(renderX + 1, renderY + 5 + singleMetalY, 7 + 6 * cap.getAllomancyPower(), 1 + singleMetalY, 3, 10 - singleMetalY);
            gig.blit(renderX, renderY, 0, 0, 5, 20);
            if (cap.getMetalBurning(cap.getAllomancyPower())) {
                gig.blit(renderX, renderY + 5 + singleMetalY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (animationCounter > 6) {
                animationCounter = 0;
                if (++currentFrame > 3) {
                    currentFrame = 0;
                }
            }
        }
        if (cap.getAllomancyPower() == 8) {
            int ironY = 9 - cap.getMetalAmounts(0);
            gig.blit(renderX + 1, renderY + 5 + ironY, 7, 1 + ironY, 3, 10 - ironY);
            int steelY = 9 - cap.getMetalAmounts(1);
            gig.blit(renderX + 8, renderY + 5 + steelY, 13, 1 + steelY, 3, 10 - steelY);
            int tinY = 9 - cap.getMetalAmounts(2);
            gig.blit(renderX + 26, renderY + 5 + tinY, 19, 1 + tinY, 3, 10 - tinY);
            int pewterY = 9 - cap.getMetalAmounts(3);
            gig.blit(renderX + 33, renderY + 5 + pewterY, 25, 1 + pewterY, 3, 10 - pewterY);
            int zincY = 9 - cap.getMetalAmounts(4);
            gig.blit(renderX + 51, renderY + 5 + zincY, 31, 1 + zincY, 3, 10 - zincY);
            int brassY = 9 - cap.getMetalAmounts(5);
            gig.blit(renderX + 58, renderY + 5 + brassY, 37, 1 + brassY, 3, 10 - brassY);
            int copperY = 9 - cap.getMetalAmounts(6);
            gig.blit(renderX + 76, renderY + 5 + copperY, 43, 1 + copperY, 3, 10 - copperY);
            int bronzeY = 9 - cap.getMetalAmounts(7);
            gig.blit(renderX + 83, renderY + 5 + bronzeY, 49, 1 + bronzeY, 3, 10 - bronzeY);
            gig.blit(renderX, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 7, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 25, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 32, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 50, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 57, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 75, renderY, 0, 0, 5, 20);
            gig.blit(renderX + 82, renderY, 0, 0, 5, 20);
            if (cap.getMetalBurning(0)) {
                gig.blit(renderX, renderY + 5 + ironY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(1)) {
                gig.blit(renderX + 7, renderY + 5 + steelY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(2)) {
                gig.blit(renderX + 25, renderY + 5 + tinY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(3)) {
                gig.blit(renderX + 32, renderY + 5 + pewterY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(4)) {
                gig.blit(renderX + 50, renderY + 5 + zincY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(5)) {
                gig.blit(renderX + 57, renderY + 5 + brassY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(6)) {
                gig.blit(renderX + 75, renderY + 5 + copperY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (cap.getMetalBurning(7)) {
                gig.blit(renderX + 82, renderY + 5 + bronzeY, ClientUtils.Frames[ClientUtils.currentFrame].x, ClientUtils.Frames[ClientUtils.currentFrame].y, 5, 3);
            }
            if (animationCounter > 6) {
                animationCounter = 0;
                if (++currentFrame > 3) {
                    currentFrame = 0;
                }
            }
        }
    }

    public static void toggleMetalBurn(byte metal, AllomancyCapability capability) {
        Network.sendToServer(new UpdateBurnPacket(metal, !capability.getMetalBurning(metal)));
        if (capability.getMetalAmounts(metal) > 0) {
            capability.setMetalBurning(metal, !capability.getMetalBurning(metal));
        }
        if (capability.getMetalBurning(metal)) {
            player.func_184185_a(new SoundEvent(new ResourceLocation("item.flintandsteel.use")), 1.0f, 5.0f);
        } else {
            player.func_184185_a(new SoundEvent(new ResourceLocation("block.fire.extinguish")), 1.0f, 4.0f);
        }
    }
}

