/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.client.gui;

import com.legobmw99.allomancy.client.ClientSetup;
import com.legobmw99.allomancy.client.ClientUtils;
import com.legobmw99.allomancy.setup.AllomancyConfig;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Vector2f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public class MetalSelectScreen
extends Screen {
    private static final String[] METAL_NAMES = new String[]{"Iron", "Steel", "Tin", "Pewter", "Zinc", "Brass", "Copper", "Bronze"};
    private static final String GUI_METAL = "allomancy:textures/gui/metals/sign%d.png";
    private static final ResourceLocation[] METAL_ICONS = new ResourceLocation[]{new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 0)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 1)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 2)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 3)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 4)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 5)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 6)), new ResourceLocation(String.format("allomancy:textures/gui/metals/sign%d.png", 7))};
    int timeIn = AllomancyConfig.animate_selection ? 0 : 10;
    int slotSelected = -1;
    AllomancyCapability cap;
    List<Integer> slots;
    Minecraft mc;

    public MetalSelectScreen() {
        super((ITextComponent)new StringTextComponent("allomancy_gui"));
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        this.cap = AllomancyCapability.forPlayer((Entity)player);
        this.mc = Minecraft.func_71410_x();
        this.slots = new ArrayList<Integer>();
        for (int i = 0; i < 8; ++i) {
            this.slots.add(i);
        }
    }

    public void render(int mx, int my, float partialTicks) {
        GlStateManager.pushMatrix();
        GlStateManager.disableTexture();
        int x = this.width / 2;
        int y = this.height / 2;
        int maxRadius = 80;
        boolean mouseIn = true;
        float angle = MetalSelectScreen.mouseAngle(x, y, mx, my);
        GlStateManager.enableBlend();
        GlStateManager.shadeModel((int)7425);
        int segments = this.slots.size();
        float totalDeg = 0.0f;
        float degPer = 360.0f / (float)segments;
        ArrayList<int[]> stringPositions = new ArrayList<int[]>();
        this.slotSelected = -1;
        for (int seg = 0; seg < segments; ++seg) {
            boolean mouseInSector = mouseIn && angle > totalDeg && angle < totalDeg + degPer;
            float radius = Math.max(0.0f, Math.min(((float)this.timeIn + partialTicks - (float)seg * 6.0f / (float)segments) * 40.0f, (float)maxRadius));
            GL11.glBegin((int)6);
            float gs = 0.3f;
            if (seg % 2 == 1) {
                gs += 0.25f;
            }
            gs = this.cap.getMetalAmounts((seg + 4) % 8) == 0 ? 0.0f : gs;
            float r = this.cap.getMetalBurning((seg + 4) % 8) ? 1.0f : gs;
            float g = gs;
            float b = gs;
            float a = 0.6f;
            if (mouseInSector) {
                this.slotSelected = seg;
            }
            GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
            GL11.glVertex2i((int)x, (int)y);
            for (float i = degPer; i >= 0.0f; i -= 1.0f) {
                float rad = (float)((double)((i + totalDeg) / 180.0f) * Math.PI);
                double xp = (double)x + Math.cos(rad) * (double)radius;
                double yp = (double)y + Math.sin(rad) * (double)radius;
                if (i == (float)((int)(degPer / 2.0f))) {
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, mouseInSector ? 110 : 114});
                    stringPositions.add(new int[]{seg, (int)xp, (int)yp, this.cap.getMetalAmounts((seg + 4) % 8) == 0 ? 55 : 102});
                }
                GL11.glVertex2d((double)xp, (double)yp);
            }
            totalDeg += degPer;
            GL11.glVertex2i((int)x, (int)y);
            GL11.glEnd();
        }
        GlStateManager.shadeModel((int)7424);
        GlStateManager.enableTexture();
        for (int[] pos : stringPositions) {
            int slot = this.slots.get(pos[0]);
            int xp = pos[1];
            int yp = pos[2];
            char c = (char)pos[3];
            int xsp = xp - 4;
            int ysp = yp;
            String name = "\u00a7" + c + METAL_NAMES[(slot + 4) % 8];
            int width = this.mc.func_175598_ae().func_78716_a().func_78256_a(name);
            if (xsp < x) {
                xsp -= width - 8;
            }
            if (ysp < y) {
                ysp -= 9;
            }
            this.mc.func_175598_ae().func_78716_a().func_175063_a(name, (float)xsp, (float)ysp, 0xFFFFFF);
            double mod = 0.8;
            int xdp = (int)((double)(xp - x) * mod + (double)x);
            int ydp = (int)((double)(yp - y) * mod + (double)y);
            this.mc.func_175598_ae().field_78724_e.func_110577_a(METAL_ICONS[(slot + 4) % 8]);
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            MetalSelectScreen.blit((int)(xdp - 8), (int)(ydp - 8), (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
        float stime = 5.0f;
        float fract = Math.min(stime, (float)this.timeIn + partialTicks) / stime;
        float s = 3.0f * fract;
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderHelper.func_74520_c();
        RenderHelper.func_74518_a();
        GlStateManager.disableBlend();
        GlStateManager.disableRescaleNormal();
        GlStateManager.popMatrix();
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        this.toggleSelected();
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    public void tick() {
        ++this.timeIn;
        super.tick();
    }

    public boolean func_223281_a_(int keysym, int scancode, int p_keyReleased_3_) {
        if (ClientSetup.burn.func_197976_a(keysym, scancode)) {
            this.mc.func_147108_a(null);
            this.mc.field_71417_B.func_198034_i();
            return true;
        }
        return super.func_223281_a_(keysym, scancode, p_keyReleased_3_);
    }

    private void toggleSelected() {
        if (this.slotSelected != -1) {
            int slot = this.slots.get(this.slotSelected);
            slot = (slot + 4) % 8;
            ClientUtils.toggleMetalBurn((byte)slot, this.cap);
            this.mc.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 0.1f, 2.0f);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private static float mouseAngle(int x, int y, int mx, int my) {
        Vector2f baseVec = new Vector2f(1.0f, 0.0f);
        Vector2f mouseVec = new Vector2f((float)(mx - x), (float)(my - y));
        float ang = (float)(Math.acos(baseVec.dot(mouseVec) / (baseVec.length() * mouseVec.length())) * 57.29577951308232);
        return my < y ? 360.0f - ang : ang;
    }
}

