/*
 * Decompiled with CFR 0.152.
 */
package com.legobmw99.allomancy.command;

import com.legobmw99.allomancy.command.AllomancyPowerType;
import com.legobmw99.allomancy.network.Network;
import com.legobmw99.allomancy.network.packets.AllomancyCapabilityPacket;
import com.legobmw99.allomancy.util.AllomancyCapability;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.function.Predicate;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class AllomancyPowerCommand {
    private static final String[] names = new String[]{"none", "iron_misting", "steel_misting", "tin_misting", "pewter_misting", "zinc_misting", "brass_misting", "copper_misting", "bronze_misting", "mistborn"};

    private static Predicate<CommandSource> permissions(int level) {
        return player -> player.func_197034_c(level);
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.func_197057_a((String)"allomancy").requires(AllomancyPowerCommand.permissions(0));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"get").requires(AllomancyPowerCommand.permissions(0))).executes(ctx -> AllomancyPowerCommand.getPower((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.getPower((CommandContext<CommandSource>)ctx, true))));
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").requires(AllomancyPowerCommand.permissions(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"type", (ArgumentType)AllomancyPowerType.INSTANCE).executes(ctx -> AllomancyPowerCommand.setPower((CommandContext<CommandSource>)ctx, false))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(ctx -> AllomancyPowerCommand.setPower((CommandContext<CommandSource>)ctx, true)))));
        LiteralCommandNode command = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ap").requires(AllomancyPowerCommand.permissions(0))).redirect((CommandNode)command));
    }

    private static int getPower(CommandContext<CommandSource> ctx, boolean hasPlayer) throws CommandSyntaxException {
        int i = 0;
        if (hasPlayer) {
            for (ServerPlayerEntity p : EntityArgument.func_197090_e(ctx, (String)"targets")) {
                AllomancyPowerCommand.getPower(ctx, p);
                ++i;
            }
        } else {
            AllomancyPowerCommand.getPower(ctx, ((CommandSource)ctx.getSource()).func_197035_h());
            i = 1;
        }
        return i;
    }

    private static int getPower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        byte power = cap.getAllomancyPower();
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.getpower", new Object[]{player.func_145748_c_(), names[power + 1]}), true);
        return power;
    }

    private static int setPower(CommandContext<CommandSource> ctx, boolean hasPlayer) throws CommandSyntaxException {
        int i = 0;
        if (hasPlayer) {
            for (ServerPlayerEntity p : EntityArgument.func_197090_e(ctx, (String)"targets")) {
                AllomancyPowerCommand.setPower(ctx, p);
                ++i;
            }
        } else {
            AllomancyPowerCommand.setPower(ctx, ((CommandSource)ctx.getSource()).func_197035_h());
            i = 1;
        }
        return i;
    }

    private static int setPower(CommandContext<CommandSource> ctx, ServerPlayerEntity player) {
        AllomancyCapability cap = AllomancyCapability.forPlayer((Entity)player);
        String type = (String)ctx.getArgument("type", String.class);
        byte power = AllomancyPowerCommand.powerTypeToByte(type);
        cap.setAllomancyPower(power);
        for (int i = 0; i < 8; ++i) {
            cap.setMetalBurning(i, false);
        }
        Network.sendTo((Object)new AllomancyCapabilityPacket(cap, player.func_145782_y()), player);
        ((CommandSource)ctx.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.allomancy.setpower", new Object[]{player.func_145748_c_(), names[power + 1]}), true);
        return power;
    }

    private static byte powerTypeToByte(String type) {
        for (byte i = 0; i <= 9; i = (byte)((byte)(i + 1))) {
            if (!type.equals(names[i])) continue;
            i = (byte)(i - 1);
            return i;
        }
        return -1;
    }
}

